package cn.smarthse.modules.health.enums.hccheckplan;

import java.util.HashMap;
import java.util.Map;

/**
 * 《》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <职业病危害因素检测结果汇总枚举>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author BinXu(徐斌) [784514607@qq.com]
 * @since 2017年7月20日-下午1:38:17
 */
public enum ResultCollectTypeEnum {
	CHEMICAL(1,"化学因素",1,"getCollectChemicalPage","colellectchemicaltr","editCollectChemicalPage",
			 "getCollectChemicalStaffPage"
			 ,"HX",3,8,"getCollectChemicalHarmPage"),
	 DUST(2,"粉尘",1,"getCollectDustPage","colellectdusttr","editCollectdustPage" 
			 ,"getCollectDustStaffPage"
			 ,"FC",3,12,"getCollectDustHarmPage"),
	 BIOLOGICAL(3,"生物因素",1,"getCollectBiologicalPage","colellectbiologicaltr","editCollectBiologicaloPage"
			 ,"getCollectBiologicalStaffPage"
			 ,"SW",3,8,"getCollectBiologicalHarmPage"),
	 NOISE(4,"噪声",2,"getCollectNoisePage","collectnoisetr","editCollectNoisePage"
			 ,"getCollectNoiseStaffPage"
			 ,"WL1",2,9,"getCollectNoiseHarmPage"),
	 HIGHFREQUENCY(5,"高频电磁场",2,"getCollectHighFrequencyPage","collecthighfrequencytr","editCollectHighfrequencyPage"
			 ,"getCollectHighFrequencyStaffPage"
			 ,"WL13",2,6,"getCollectHighFrequencyHarmPage"),
	 IONIZINGRADIATION(6,"电离辐射",2,"getCollectIonizingradiationPage","collectionizingradiationtr","editCollectIonizingradiationPage"
			 ,"getCollectIonizingradiationStaffPage"
			 ,"WL17",3,8,"getCollectIonizingradiationHarmPage"),
	 ULTRAHIGHFREQUENCYRADIATION(7,"超高频辐射",2,"getCollectUltrahighfrequencyradiationPage","collectultrahighfrequencyradiationtr","editCollectUltrahighfrequencyradiationPage"
			 ,"getCollectUltrahighfrequencyradiationStaffPage"
			 ,"WL14",2,6,"getCollectUltrahighfrequencyradiationHarmPage"),
	 HANDTRANSMITTED(8,"手传振动",2,"getCollectHandtransmittedPage","collecthandtransmittedtr","editCollectHandTransmittedPage"
			 ,"getCollectHandtransmittedStaffPage"
			 ,"WL6",2,4,"getCollectHandtransmittedHarmPage"),
	 MICROWAVERADIATION (9,"微波辐射",2,"getCollectMicrowaveradiationPage","collectmicrowaveradiationtr","editCollectMicrowaveRadiationPage"
			 ,"getCollectMicrowaveradiationStaffPage"
			 ,"WL9",2,8,"getCollectMicrowaveradiationHarmPage"),
	 ULTRAVIOLETLIGHT(10,"紫外辐射",2,"getCollectUltravioletlightPage","collectultravioletlighttr","editCollectUltravioletLightPage"
			 ,"getCollectUltravioletlightStaffPage"
			 ,"WL10",3,15,"getCollectUltravioletlightHarmPage"),  
	 POWERFREQUENCY(11,"工频电场",2,"getCollectPowerfrequencyPage","collectpowerfrequencytr","editCollectPowerFrequencyPage"
			 ,"getCollectPowerfrequencyStaffPage"
			 ,"WL12",2,4,"getCollectPowerfrequencyHarmPage"),
	 HIGHTEMPERATURE(12,"高温",2,"getCollectHightemperaturePage","collecthightemperaturetr","editCollectHightemperaturePage"
			 ,"getCollectHightemperatureStaffPage"
			 ,"WL2",2,5,"getCollectHightemperatureHarmPage"), 
	 LASERRADIATION(13,"激光辐射",2,"getCollectLaserradiationPage","collectlaserradiationtr","editCollectLaserRadiationPage"
			 ,"getCollectLaserradiationStaffPage"
			 ,"WL7",2,9,"getCollectLaserradiationHarmPage"),
	 ILLUMINANCY(14,"照度",3,"getCollectIlluminancyPage","collectilluminancytr","editCollectIlluminancyPage"
			 ,"collectilluminancystaff"
			 ,null,2,3,null),
	 MICROCLIMATE(15,"微小气候",3,"getCollectMicroclimatePage","collectmicroclimatetr","editCollectMicroclimatePage"
			 ,"collectmicroclimatestaff"
			 ,null,2,7,null),
	 WINDSPEED(16,"控制风速",3,"getCollectWindspeedPage","collectwindspeedtr","editCollectWindSpeedPage"
			 ,"collectwindspeedstaff"
			 ,null,2,3,null), 
	 FRESHAIRRATE(17,"新风量",3,"getCollectFreshairratePage","collectfreshairratetr","editCollectFreshAirratePage"
			 ,"collectfreshairratestaff"
			 ,null,2,5,null);
	 
	 private Integer code; //编号
	 
	 private String name; //名称
	 
	 private Boolean selected; //是否选中
	 
	 private  Integer groupId; //组号
	 
	 private  String page; //所对应的界面
	 
	 private String pageEdit; //所对应的编辑界面
	 
	 private String trPage;  //tr片段用于新增 编辑操作
	 
	 private String staffPage;  //人员岗位相关界面
	 
	 private String paramCode;//test库里面，危害因素的编码，如果是null，则需要具体的子类危害因素编码
	 
	 private Integer startRowNum;//在导入模板中第几行开始有数据(从0开始)
	 
	 private Integer validCol;//在导入模板中的有效列(从1开始)
	 
	 private String  harmManagerPage;//危害因素管理模块使用(1到13个大类)
	 
	 
	 
	 
	 private ResultCollectTypeEnum(Integer code,String name,Integer groupId,String page,String trPage,
			 String pageEdit,String staffPage,String paramCode,Integer startRowNum,Integer validCol,String harmManagerPage){
		 this.code=code;
		 this.name=name;
		 this.groupId=groupId;
		 this.page=page;
		 this.pageEdit=pageEdit;
		 this.trPage=trPage;
		 this.staffPage=staffPage;
		 this.paramCode=paramCode;
		 this.startRowNum=startRowNum;
		 this.validCol=validCol;
		 this.harmManagerPage=harmManagerPage;
	 }

	 
	/**
	 * 根据危害因素，获取结果相关配置枚举数据
	 * <li>add by shao @20170402
	 * @param num
	 * @return
	 */
   public static ResultCollectTypeEnum getResultTypeByCode(Integer code){
   	for (ResultCollectTypeEnum c : values()) {  
           if (code.intValue() == c.getCode().intValue()) {  
               return c;  
           }  
       }  
   	
       return null;  
   }
	 
	 
	 
	 public static  String getCodeByName(String name){
		for(ResultCollectTypeEnum r:ResultCollectTypeEnum.values()){
			if(r.getName().equals(name)){
				
			}
		}   
		 return "";
	 }
	 public static  String getNameByCode(Integer code){
		 String name="";
			for(ResultCollectTypeEnum r:ResultCollectTypeEnum.values()){
				if(r.getCode()==code){
					name=r.getName();
				}
			}   
			 return name;
		 }
	 
	public Boolean getSelected() {
		return selected;
	}

	public void setSelected(Boolean selected) {
		this.selected = selected;
	}

	public Integer getCode() {
		return code;
	}

	public String getName() {
		return name;
	}

	public Integer getGroupId() {
		return groupId;
	}
	public String getPage() {
		return page;
	}
	public String getPageEdit() {
		return pageEdit;
	}
	public String getTrPage() {
		return trPage;
	}
	public String getStaffPage() {
		return staffPage;
	}

	public String getParamCode() {
		return paramCode;
	}

//	public void setParamCode(String paramCode) {
//		this.paramCode = paramCode;
//	}
	
	public String getHarmManagerPage() {
		return harmManagerPage;
	}

	
   public  static String getParamCodeByCode(String code){
   	String paramCode="";
   	ResultCollectTypeEnum[] values=ResultCollectTypeEnum.values();
   	for(ResultCollectTypeEnum r:values){
   		if((r.code+"").equals(code)){
   			paramCode=r.paramCode;
   			break;
   		}
   	}
   	return paramCode;
   }
   public static  Integer  getCodeByParamCode(String paramCode){
   	Integer code=null;
   	ResultCollectTypeEnum[] values=ResultCollectTypeEnum.values();
   	for(ResultCollectTypeEnum r:values){
   		if(paramCode!=null&&paramCode.equals(r.getParamCode())){
   			code=r.getCode();
   			break;
   		}
   	}
   	
   	return code;
   }
   public  static ResultCollectTypeEnum  getThisEnumByCode(Integer code){
	   ResultCollectTypeEnum[] values=ResultCollectTypeEnum.values();
	   for(ResultCollectTypeEnum r:values){
	    	 if(r.getCode()==code){
	    		 return r;
	    	 }
	    }
	   return null;
   }
   public Integer getValidCol() {
	return validCol;
   }

	public Integer getStartRowNum() {
		return startRowNum;
	}
	
	/**
	 * 
	 * @Comments:  <以枚举中的name的属性作为key,以name对应的具体枚举作为value组成的map>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月30日-下午2:45:12
	 * @return
	 */
	public  static Map<String, ResultCollectTypeEnum> getThisEnumMapByName(){
		Map<String, ResultCollectTypeEnum> map=new HashMap<String, ResultCollectTypeEnum>();
		ResultCollectTypeEnum[] values=ResultCollectTypeEnum.values();
		for(ResultCollectTypeEnum r:values){
			map.put(r.getName(), r);
		}
		return map;
	}
	public  static ResultCollectTypeEnum  getThisEnumByName(String name){
		   ResultCollectTypeEnum[] values=ResultCollectTypeEnum.values();
		   for(ResultCollectTypeEnum r:values){
		    	 if(r.getName().equals(name)){
		    		 return r;
		    	 }
		    }
		   return null;
	   }
}
