package cn.smarthse.modules.health.enums.hccheckplan;

import cn.hutool.core.util.StrUtil;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

import static cn.hutool.core.text.CharSequenceUtil.isBlank;

@Getter
@AllArgsConstructor
public enum OccTypeEnum {

    ALLTYPE("全部危害因素", 0),
    DUSTTYPE("粉尘", 1),            // 仅粉尘-11
    CHEMICALTYPE("化学因素", 2),    // 仅化学因素-12
    BIOLOGICALTYPE("生物因素", 3),    // 仅生物因素-13
    PHYSICALTYPE("物理因素", 4),    // 仅物理因素-14
    RADIATIONTYPE("放射因素", 5),    // 仅放射因素-15
    OTHERTYPE("其他因素", 6);        // 仅其他因素-16

    private final String name;
    private final Integer type;


    public static OccTypeEnum getThisEnumByType(Integer type) {
        OccTypeEnum[] list = OccTypeEnum.values();
        for (OccTypeEnum occ : list) {
            if (Objects.equals(occ.getType(), type)) {
                return occ;
            }
        }
        return null;
    }

    public static OccTypeEnum getThisEnumByName(String name) {
        if (isBlank(name)) {
            return null;
        }
        for (OccTypeEnum t : OccTypeEnum.values()) {
            if (Objects.equals(t.getName(), name)) {
                return t;
            }
        }
        return null;
    }

}
