package cn.smarthse.modules.health.enums.hccheckplan;

/**
 * hc检查枚举类型 （3.2.2.1版本修改了）
 * 《》
 *
 * @Project: smarthse-facade
 * @Module ID:   <四个固定的检测类型枚举，其他自定义的需要从数据库里面去>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7>
 * @date 2023-05-08
 */
public enum HcCheckTypeEnum {
	DAILY("日常监测",1L),
	REGULAR("定期检测",2L),
	PRESENT("现状评价",3L),
	CONTROLASSESSMENT("控评效果评价",4L),
	//下面应该都没有用
	// 数据库：整改后的检测（实施版） 也是5
	SUPERVISE("监督检测",5L),
	OTHERCHECK("其他检测",90L);

	private String name;
	private Long value;

	private HcCheckTypeEnum(String name,Long value){
		this.name=name;
		this.value=value;
	}
	public String getName() {
		return name;
	}
	public Long getValue() {
		return value;
	}

	public static HcCheckTypeEnum  getThisEnumByValue(Long value){
		HcCheckTypeEnum[] list=HcCheckTypeEnum.values();
		for(HcCheckTypeEnum h:list){
			if(h.getValue()==value){
				return h;
			}
		}
		return null;
	}
}
