package cn.smarthse.modules.health.enums.hccheckplan;

public enum ExportCollectResultNewEnum {
	CHEMICAL(1,"化学因素",new String[]{"workshopName","workName","harmStaffCount","checkObject","checkProject","me","twa","ste","peakCon","reductionFactor","judged"}),
//	DUST(2,"粉尘",new String[]{"workName","workshopName","harmStaffCount","checkObject","checkProject","totalTwa","totalPeak","totalResult","respTwa","respPeak","reductionFactorResp","respResult"}),
	DUST(2,"粉尘",new String[]{"workshopName","workName","harmStaffCount","checkObject","checkProject","totalTwa","totalPeak","totalResult","respTwa","respPeak","reductionFactorResp","respResult"}),
	NOISE(3,"噪声",new String[]{"workshopName","workName","harmStaffCount","checkObject","noiseType","checkedNum","minNum","maxNum","level","times","peak","judged"}),
	HIGHTEMPERATURE(4,"高温",new String[]{"workshopName","workName","harmStaffCount","checkObject","contactRate","strength","checkResult","judged"}),
	ULTRAVIOLETLIGHT(5,"紫外辐射",new String[]{"workshopName","workName","harmStaffCount","checkObject","ultraType","contactTime","uw","mj","judged","uwEye","mjEye","judgedEye",
			"uwFace","mjFace","judgedFace","uwNone","mjNone","judgedNone"}),
	POWERFREQUENCY(6,"工频电场",new String[]{"workshopName","workName","harmStaffCount","checkObject","contactTime","powerLevel","judged"}),
	MICROWAVERADIATION (7,"微波辐射",new String[]{"workshopName","workName","harmStaffCount","checkObject","type1","type2","hour","daliy","avg","mw","judged"}),
	HIGHFREQUENCY(8,"高频电磁场",new String[]{"workshopName","workName","harmStaffCount","checkObject","rate","hour","powerLevel","freLevel","judged"}),
	ULTRAHIGHFREQUENCYRADIATION(9,"超高频辐射",new String[]{"workshopName","workName","harmStaffCount","checkObject","type","hour","mw","powerLevel","judged"}),
	IONIZINGRADIATION(10,"电离辐射",new String[]{"name"}),//单独自定义
	HANDTRANSMITTED(11,"手传振动",new String[]{"workshopName","workName","harmStaffCount","checkObject","hour","speed","judged"}),
	LASERRADIATION(12,"激光辐射",new String[]{"workshopName","workName","harmStaffCount","checkObject","position","hour","range","len","time","j","w","judged"}),
	BIOLOGICAL(13,"生物因素",new String[]{"workshopName","workName","harmStaffCount","checkObject","checkProject","me","twa","ste","reductionFactor","judged"}),
	ILLUMINANCY(14,"照度",new String[]{"workshopName","workName","harmStaffCount","checkObject","checkResult","judged"}),
	MICROCLIMATE(15,"微小气候",new String[]{"workshopName","workName","harmStaffCount","checkObject","tempResult","tempJudged","speedResult","speedJudged","humidityResult","humidityJudged"}),
	FRESHAIRRATE(16,"新风量",new String[]{"workshopName","workName","harmStaffCount","checkObject","isDirty","checkResult","num","avg","judged"}),
	WINDSPEED(17,"控制风速",new String[]{"workshopName","workName","harmStaffCount","checkObject","checkResult","judged"});
	private ExportCollectResultNewEnum(Integer code, String name, String[] attrs) {
		this.code=code;
		this.name=name;
		this.attrs=attrs;
	}
	
    private Integer code; //编号
	 
	 private String name; //名称
	 
	 private String[] attrs;//需要导出属性
	 
	 public Integer getCode() {
		return code;
	}
	 public String getName() {
		return name;
	}
	 public String[] getAttrs() {
		return attrs;
	}
	 
	 public static ExportCollectResultNewEnum getResultTypeByCode(Integer code){
		   	for (ExportCollectResultNewEnum c : ExportCollectResultNewEnum.values()) {
		           if (code.intValue() == c.getCode().intValue()) {  
		               return c;  
		           }  
		       }
		       return null;  
	}
	
}
