package cn.smarthse.modules.health.enums.hccheckplan;

public enum ExportCollectResultEnum {
	CHEMICAL(1,"化学物质",new String[]{"reportName","harmName","cmac","ctwa","cstel","peakcontactconcentration","times","resultName"}),
	 DUST(2,"粉尘",new String[]{"reportName","harmName","ctwa1","ctwa1range","peakcontactconcentration1","times1","resultName","ctwa2","ctwa2range","peakcontactconcentration2","times2","resultName1"}),
	 BIOLOGICAL(3,"生物因素",new String[]{"reportName","harmName","cmac","ctwa","cstel","resultName"}),
	 NOISE(4,"噪声",new String[]{"reportName","noiseTypeName","checkValue","minValue","maxValue","equalLevel","times","maxNoise","resultName"}),
	 HIGHFREQUENCY(5,"高频电磁场",new String[]{"reportName","frequency","time","estrong","mstrong","resultName"}),
	 IONIZINGRADIATION(6,"电离辐射",new String[]{"reportName"}),//单独自定义
	 ULTRAHIGHFREQUENCYRADIATION(7,"超高频辐射",new String[]{"reportName","typeName","time","power","electric","resultName"}),
	 HANDTRANSMITTED(8,"手传振动",new String[]{"reportName","time","speed","resultName"}),
	 MICROWAVERADIATION (9,"微波辐射",new String[]{"reportName","typeName1","typeName2","time","amount","avgDensity","powerDensity","resultName"}),
	 ULTRAVIOLETLIGHT(10,"紫外辐射",new String[]{"reportName","classifyName","time","irradiance","exposure","resultName","irradiance1","exposure1","resultName1",
			 "irradiance2","exposure2","resultName2","irradiance3","exposure3","resultName3"}),  
	 POWERFREQUENCY(11,"工频电场",new String[]{"reportName","time","power","resultName"}),
	 HIGHTEMPERATURE(12,"高温",new String[]{"reportName","time","strongName","checkResult","resultName"}), 
	 LASERRADIATION(13,"激光辐射",new String[]{"reportName","locationName","time","rangeName","waveLength","irradiationTime","exposure","irradiance","resultName"}),
	 ILLUMINANCY(14,"照度",new String[]{"reportName","checkResult","resultName"}),
	 MICROCLIMATE(15,"微小气候",new String[]{"reportName","checkResult1","resultName1","checkResult2","resultName2","checkResult3","resultName3"}),
	 WINDSPEED(16,"控制风速",new String[]{"reportName","checkResult","resultName"}), 
	 FRESHAIRRATE(17,"新风量",new String[]{"reportName","clearhouseName","checkResult","personcount","everyonevalue","resultName"});
	private ExportCollectResultEnum(Integer code,String name,String[] attrs) {
		this.code=code;
		this.name=name;
		this.attrs=attrs;
	}
	
    private Integer code; //编号
	 
	 private String name; //名称
	 
	 private String[] attrs;//需要导出属性
	 
	 public Integer getCode() {
		return code;
	}
	 public String getName() {
		return name;
	}
	 public String[] getAttrs() {
		return attrs;
	}
	 
	 public static ExportCollectResultEnum getResultTypeByCode(Integer code){
		   	for (ExportCollectResultEnum c : ExportCollectResultEnum.values()) {  
		           if (code.intValue() == c.getCode().intValue()) {  
		               return c;  
		           }  
		       }
		       return null;  
	}
	
}
