package cn.smarthse.modules.health.enums.evaluate;

import cn.smarthse.modules.health.enums.device.RadiationDeviceTypeEnum;

/**
 * 
 * 《评价类型》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @since 2017年11月10日-下午3:45:03
 */
public enum EvaluateTypeEnum {
//	1职业病危害现状评价  
	OCC_NOW_EVALUATE("职业病危害现状评价",(byte)1),
	OCC_PRE_EVALUATE("职业病危害预评价",(byte)2),
	OCC_CONTROL_EFFC_EVALUATE("职业病危害控制效果评价",(byte)3),
	SAFE_NOW_EVALUATE("安全现状评价",(byte)4),
	SAFE_PRE_EFFC_EVALUATE("安全预评价",(byte)5),
	SAFE_ACCEPT_EVALUATE("安全验收评价",(byte)6),

	;
	EvaluateTypeEnum(String name, Byte value) {
		this.name = name;
		this.value = value;
	}
	private String name;
	private byte value;
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Byte getValue() {
		return value;
	}
	public void setValue(Byte value) {
		this.value = value;
	}
	
	public static String getEvaluateTypeName(Byte value) {
		if (value == null) {
			return "";
		}
		for (EvaluateTypeEnum c : EvaluateTypeEnum.values()) {
			if (c.getValue().equals(value)) {
				return c.name;
			}
		}
		return "";
	}
	

	public static EvaluateTypeEnum getEvaluateTypeByValue(Byte value) {
		if (value == null) {
			return null;
		}
		for (EvaluateTypeEnum c : EvaluateTypeEnum.values()) {
			if (c.getValue().equals(value)) {
				return c;
			}
		}
		return null;
	}
	
}
