package cn.smarthse.modules.health.enums.evaluate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import cn.smarthse.modules.health.enums.thirdtime.TsProjectPhraseEnum;

public enum EvaluateHdLevel {
//	1职业病危害现状评价  
	HD_NOW_REFORM("一般事故隐患 现场立即整改",(byte)1),
	HD_DEAD_DATE_REFORM("一般事故隐患 限期整改",(byte)2),
	HD_STOP_REFORM("重大事故隐患 停产停业整顿",(byte)3),
	
	;
	EvaluateHdLevel(String name, Byte value) {
		this.name = name;
		this.value = value;
	}
	private String name;
	private byte value;
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Byte getValue() {
		return value;
	}
	public void setValue(Byte value) {
		this.value = value;
	}
	
	public static String getEvaluateHdLevelName(Byte value) {
		if (value == null) {
			return "";
		}
		for (EvaluateHdLevel c : EvaluateHdLevel.values()) {
			if (c.getValue().equals(value)) {
				return c.name;
			}
		}
		return "";
	}
	

	public static List<Map<String,Object>> getAllValues() {
		EvaluateHdLevel[] tsp = EvaluateHdLevel.values();
		List<Map<String,Object>> list= new ArrayList<Map<String,Object>>();
		for(EvaluateHdLevel ts : tsp) {
			Map<String,Object> data = new HashMap<String,Object>();
			data.put("value", ts.getValue());
			data.put("name", ts.getName());
			list.add(data);
		}
		return list;
	}
}
