package cn.smarthse.modules.health.enums.datascope;

import cn.smarthse.modules.health.enums.accident.LevelEnum;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: DataScope
 * @Project: ${MODEL_NAME}
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 18
 * @since 2019/10/9-11:18
 */
public enum DataScopeEnum {
    ALL("全厂",(byte)1),
    DEPARTMENT("部门",(byte)2),
    PERSONAL("个人",(byte)3),
    ;

    // 成员变量
    private String name;
    private Byte code;
    // 构造方法

    private DataScopeEnum(String name, Byte code) {
        this.name = name;
        this.code = code;
    }
    // 普通方法
    public static String getName(Byte code) {
        if (code == null) {
            return null;
        }
        for (DataScopeEnum c : DataScopeEnum.values()) {
            if (c.getCode().byteValue()==code.byteValue()) {
                return c.name;
            }
        }
        return null;
    }


    public static DataScopeEnum getDataScopeEnum(Byte code) {
        if (code == null) {
            return null;
        }
        for (DataScopeEnum c : DataScopeEnum.values()) {
            if (c.getCode().byteValue()==code.byteValue()) {
                return c;
            }
        }
        return null;
    }


    // get set 方法
    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }
    public Byte getCode() {
        return code;
    }
    public void setCode(Byte code) {
        this.code = code;
    }
}
