package cn.smarthse.modules.health.enums.company.govern;

import cn.smarthse.common.util.StringUtils;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: CompanyGovernReformStatus
 * @Project:
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 19
 * @since 2022/2/22-11:19
 */
public enum CompanyGovernReformStatusEnum {
    //0整改无望、1整改超时、2整改中、3已整改,   -1 异常数据
    HOPELESS("整改无望",0),
    OVERTIME ("整改超时",1),
    ING("整改中",2),
    FINISH("已整改",3),

    ;

    // 成员变量
    private String name;
    private Integer code;
    // 构造方法

    private CompanyGovernReformStatusEnum(String name, Integer code) {
        this.name = name;
        this.code = code;
    }
    // 普通方法
    public static String getName(Byte code) {
        if (code == null) {
            return null;
        }
        for (CompanyGovernReformStatusEnum c : CompanyGovernReformStatusEnum.values()) {
            if ((new Byte(c.getCode().byteValue())).equals(code)) {
                return c.name;
            }
        }
        return null;
    }// 普通方法
    public static Integer getCodeByName(String name) {
        if (StringUtils.isEmpty(name)) {
            return null;
        }
        for (CompanyGovernReformStatusEnum c : CompanyGovernReformStatusEnum.values()) {
            if (c.getName().equals(name)) {
                return c.getCode();
            }
        }
        return null;
    }


    // get set 方法
    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }
    public Integer getCode() {
        return code;
    }
    public void setCode(Integer code) {
        this.code = code;
    }
}
