package cn.smarthse.modules.health.enums.company;

import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 
 * 职能机构类型
 * 
 * 
 * @Project:  smarthse-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author Horsy(何世壹) [hsy@smarthse.cn]
 * @since 2017年6月28日-上午11:12:06
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum FunOrgTypeEnum {
	
	occupationHealth("职业卫生",(byte)1,true),	
	//emergencyRescue("应急救援",(byte)2,false),	
	//radiationSafety("辐射安全",(byte)3,true),
	custom("自定义",(byte)4,true),
	//safeProduction("安全生产",(byte)5,true),
	; 
	
	// 成员变量
	private String name;
	private Byte code;
	private Boolean isValid;
	// 构造方法

	private FunOrgTypeEnum(String name, Byte code,Boolean isValid) {
		this.name = name;
		this.code = code;
		this.isValid=isValid;
	}
	// 普通方法
	public static String getName(Byte code) {
		if (code == null) {
			return null;
		}
		for (FunOrgTypeEnum c : FunOrgTypeEnum.values()) {
			if (c.getCode().equals(code)) {
				return c.name;
			}
		}
		return null;
	}
	
	/**
	 * 是否有负责人属性
	 * @param code
	 * @return
	 */
	public static boolean hasManager(Byte code){
		if(code == null){
			return false;
		}
		if(code.equals(FunOrgTypeEnum.occupationHealth.getCode())){
			return true;
		}
		return false;
	}
	
	public static List<FunOrgTypeEnum> getValues(){
		List<FunOrgTypeEnum> list = new ArrayList<FunOrgTypeEnum>();
		for (FunOrgTypeEnum c : FunOrgTypeEnum.values()) {
			if(c.isValid){
				list.add(c);
			}
		}
		return list;
	}
	
	
	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Byte getCode() {
		return code;
	}
	public void setCode(Byte code) {
		this.code = code;
	}
	public Boolean getIsValid() {
		return isValid;
	}
	public void setIsValid(Boolean isValid) {
		this.isValid = isValid;
	}
	
}
