package cn.smarthse.modules.health.enums.company;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 
 * 职能机构成员类型
 * 
 * 
 * @Project:  smarthse-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author Horsy(何世壹) [hsy@smarthse.cn]
 * @since 2017年6月28日-上午11:12:06
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum FunOrgMemberTypeEnum {
	
	/**
	 * 专职
	 */
	special("专职",(byte)1),
	/**
	 * 兼职
	 */
	sideline("兼职",(byte)2),
	
	; 
	
	// 成员变量
	private String name;
	private Byte code;
	// 构造方法

	private FunOrgMemberTypeEnum(String name, Byte code) {
		this.name = name;
		this.code = code;
	}
	// 普通方法
	public static String getName(Byte code) {
		if (code == null) {
			return null;
		}
		for (FunOrgMemberTypeEnum c : FunOrgMemberTypeEnum.values()) {
			if (c.getCode().equals(code)) {
				return c.name;
			}
		}
		return null;
	}
	
	
	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Byte getCode() {
		return code;
	}
	public void setCode(Byte code) {
		this.code = code;
	}
}
