package cn.smarthse.modules.health.enums.company;

import cn.smarthse.common.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum CompanySizeEnum {
	Large("大型企业",(byte)1),
	Medium ("中型企业",(byte)2),
	Small("小型企业",(byte)3),
	Micro("微型企业",(byte)4),
	Undivided("未划分",(byte)5),
	; 
	
	// 成员变量
	private String name;
	private Byte code;
	// 构造方法

	private CompanySizeEnum(String name, Byte code) {
		this.name = name;
		this.code = code;
	}


	// 普通方法
	public static String getName(Byte code) {
		if (code == null) {
			return null;
		}
		for (CompanySizeEnum c : CompanySizeEnum.values()) {
			if (c.getCode().equals(code)) {
				return c.name;
			}
		}
		return null;
	}// 普通方法
	public static Byte getCodeByName(String name) {
		if (StringUtils.isEmpty(name)) {
			return null;
		}
		for (CompanySizeEnum c : CompanySizeEnum.values()) {
			if (c.getName().equals(name)) {
				return c.getCode();
			}
		}
		return null;
	}
	
	
	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Byte getCode() {
		return code;
	}
	public void setCode(Byte code) {
		this.code = code;
	}

	public String getShortName(){
		String[] strings = name.split("企业");
		if (StringUtils.isNotEmpty(strings[0]))
			return strings[0];
		return name;
	}
}
