package cn.smarthse.modules.health.enums.check.v3221;

import cn.smarthse.modules.health.enums.check.CheckSourceEnum;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * @ author Supw
 * @ since 2023/6/28 18:00
 * 体检类型编码
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum PhyPhcCheckTypeEnum {
    BEFORE((byte)1,"上岗前职业健康检查"),
    ON((byte)2,"在岗期间职业健康检查"),
    LEAVE((byte)3,"离岗时职业健康检查"),
    AFTER_LEAVE((byte)4,"离岗后健康检查"),
    URGENT((byte)5,"应急健康检查"),
    ;

    private Byte code;
    private String name;

    PhyPhcCheckTypeEnum(Byte code, String name) {
        this.code = code;
        this.name = name;
    }

    public Byte getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
    // 普通方法
    public static String getName(Byte code) {
        if (code == null) {
            return null;
        }
        for (PhyPhcCheckTypeEnum c : PhyPhcCheckTypeEnum.values()) {
            if (c.getCode().equals(code)) {
                return c.name;
            }
        }
        return null;
    }
}
