package cn.smarthse.modules.health.enums.check;

import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum WorkStateEnum {

	before("上岗前",(byte)1),
	on("在岗期间",(byte)2),
	leave("离岗时",(byte)4),
	;

	// 成员变量
	private String name;
	private Byte code;
	// 构造方法

	private WorkStateEnum(String name, Byte code) {
		this.name = name;
		this.code = code;
	}
	// 普通方法
	public static String getName(Byte code) {
		if (code == null) {
			return null;
		}
		for (WorkStateEnum c : WorkStateEnum.values()) {
			if (c.getCode().equals(code)) {
				return c.name;
			}
		}
		return null;
	}

	
	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Byte getCode() {
		return code;
	}
	public void setCode(Byte code) {
		this.code = code;
	}
}
