package cn.smarthse.modules.health.enums.check;

import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum SuperviseDealStatusEnum {
	//0未处理 1退回 2同意
	undeal("未处理",(byte)0),
	reback("退回",(byte)1),
	pass("同意",(byte)2)
	;

	// 成员变量
	private String name;
	private Byte code;
	// 构造方法

	private SuperviseDealStatusEnum(String name, Byte code) {
		this.name = name;
		this.code = code;
	}
	// 普通方法
	public static String getName(Byte code) {
		if (code == null) {
			return null;
		}
		for (SuperviseDealStatusEnum c : SuperviseDealStatusEnum.values()) {
			if (c.getCode().equals(code)) {
				return c.name;
			}
		}
		return null;
	}

	
	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Byte getCode() {
		return code;
	}
	public void setCode(Byte code) {
		this.code = code;
	}
}
