package cn.smarthse.modules.health.enums.check;

import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum SpecialWorkEnum {
	//9.1电工作业、9.2高处作业、9.3压力容器作业、9.4结核病防治工作、9.5肝炎病防治工作、9.6职业机动车驾驶作业、9.7视屏作业、9.8高原作业、9.9航空作业
	work1("电工作业","9.1"),
	work2("高处作业","9.2"),
	work3("压力容器作业","9.3"),
	work4("结核病防治工作","9.4"),
	work5("肝炎病防治工作","9.5"),
	work6("职业机动车驾驶作业","9.6"),
	work7("视屏作业","9.7"),
	work8("高原作业","9.8"),
	work9("航空作业","9.9"),
	;
	// 成员变量
	private String name;
	private String code;
	// 构造方法

	private SpecialWorkEnum(String name, String code) {
		this.name = name;
		this.code = code;
	}
	// 普通方法
	public static String getName(String code) {
		if (code == null) {
			return null;
		}
		for (SpecialWorkEnum c : SpecialWorkEnum.values()) {
			if (c.getCode().equals(code)) {
				return c.name;
			}
		}
		return null;
	}
	
	
	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getCode() {
		return code;
	}
	public void setCode(String code) {
		this.code = code;
	}
}
