package cn.smarthse.modules.health.enums.check;

import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum RecommendCheckEnum {
	
	onChoose("在岗选检","29"),	
	onMust("在岗必检","28"),
	beforeChoose("上岗前选检","19"),
	beforeMust("上岗前必检","18"),
	leaveChoose("离岗时选检","49"),
	leaveMust("离岗时必检","48"),
	; 
	
	// 成员变量
	private String name;
	private String code;
	// 构造方法

	private RecommendCheckEnum(String name, String code) {
		this.name = name;
		this.code = code;
	}
	// 普通方法
	public static String getName(String code) {
		if (code == null) {
			return null;
		}
		for (RecommendCheckEnum c : RecommendCheckEnum.values()) {
			if (c.getCode().equals(code)) {
				return c.name;
			}
		}
		return null;
	}
	
	
	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getCode() {
		return code;
	}
	public void setCode(String code) {
		this.code = code;
	}
}
