package cn.smarthse.modules.health.enums.check;

import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum ExamResultEnum {
	
	noraml("目前未见异常","1","3"),
	recheck("复查","2","2"),
	so("疑似职业病","3","1"),
	oc("职业禁忌证","4","1"),
	other("其他疾病或异常","5","3"),
	mis("缺必检项","6","3")
	; 
	
	// 成员变量
	private String name;
	private String code;
	private String group;
	// 构造方法

	private ExamResultEnum(String name, String code,String group) {
		this.name = name;
		this.code = code;
		this.group = group;
	}

	// 普通方法
	public static String getName(String code) {
		if (code == null) {
			return null;
		}
		for (ExamResultEnum c : ExamResultEnum.values()) {
			if (c.getCode().equals(code)) {
				return c.name;
			}
		}
		return null;
	}

	public static  ExamResultEnum getThisEnumByName(String name){
        ExamResultEnum[] all=ExamResultEnum.values();

        for(ExamResultEnum examResultEnum:all){
            if(examResultEnum.getName().equals(name)){
                return examResultEnum;
            }
        }
        return null;

    }

	public static String getGroup(String code) {
		if (code == null) {
			return "";
		}
		for (ExamResultEnum c : ExamResultEnum.values()) {
			if (c.getCode().equals(code)) {
				return c.group;
			}
		}
		return "";
	}
	
	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getCode() {
		return code;
	}
	public void setCode(String code) {
		this.code = code;
	}

	public String getGroup() {
		return group;
	}

	public void setGroup(String group) {
		this.group = group;
	}
}
