package cn.smarthse.modules.health.enums.check;

import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum DiagnosedReportStatusEnum {
	draft("草稿",(byte)1),
	reported("已上报",(byte)2),
	back("被退回",(byte)3)
	;

	// 成员变量
	private String name;
	private Byte code;
	// 构造方法


	DiagnosedReportStatusEnum(String name, Byte code) {
		this.name = name;
		this.code = code;
	}

	// 普通方法
	public static String getName(Byte code) {
		if (code == null) {
			return null;
		}
		for (DiagnosedReportStatusEnum c : DiagnosedReportStatusEnum.values()) {
			if (c.getCode().equals(code)) {
				return c.name;
			}
		}
		return null;
	}


	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Byte getCode() {
		return code;
	}
	public void setCode(Byte code) {
		this.code = code;
	}
}
