package cn.smarthse.modules.health.enums.check;

import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum DiagnosedAddFromEnum {
	thirdOrg("机构端",(byte)3),
	supervise("监管端",(byte)2);

	private String name;
	private Byte code;

	DiagnosedAddFromEnum(String name, Byte code) {
		this.name = name;
		this.code = code;
	}

	public static String getName(Byte code) {
		if (code == null) {
			return null;
		}
		for (DiagnosedAddFromEnum c : DiagnosedAddFromEnum.values()) {
			if (c.getCode().equals(code)) {
				return c.name;
			}
		}
		return null;
	}

	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Byte getCode() {
		return code;
	}
	public void setCode(Byte code) {
		this.code = code;
	}
}
