package cn.smarthse.modules.health.enums.check;

import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum DealTypeEnum {
	
	recheck("复查","1"),	
	change("转岗","2"),
	diagnose("职业病诊断","3"),		
	other("其他","4"),
	noHire("不录用","5"),
	completion("补全体检项目","6"),
	noCheck("本次不再体检","7"),
    replenishCheck("补检","8");
	
	// 成员变量
	private String name;
	private String code;
	// 构造方法

	private DealTypeEnum(String name, String code) {
		this.name = name;
		this.code = code;
	}
	// 普通方法
	public static String getName(String code) {
		if (code == null) {
			return null;
		}
		for (DealTypeEnum c : DealTypeEnum.values()) {
			if (c.getCode().equals(code)) {
				return c.name;
			}
		}
		return null;
	}
	
	
	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getCode() {
		return code;
	}
	public void setCode(String code) {
		this.code = code;
	}
}
