package cn.smarthse.modules.health.enums.check;

import cn.smarthse.common.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum CheckTypeEnum {
	
	before("上岗前职业健康检查","1","上岗","岗前体检"),
	on("在岗期间职业健康检查","2","在岗","在岗体检"),
	leave("离岗时职业健康检查","3","离岗","离岗体检"),
	recheck("复查","4","复查","复查"),
	eme("应急健康检查","5","应急","应急体检"),
	left("离岗后健康检查","6","离岗后","离岗后体检"),
	; 
	
	// 成员变量
	private String name;
	private String code;
	private String shortName;
	private String thirdOrgName;
	// 构造方法

	private CheckTypeEnum(String name, String code,String shortName,String thirdOrgName) {
		this.name = name;
		this.code = code;
		this.shortName = shortName;
		this.thirdOrgName = thirdOrgName;
	}
	// 普通方法
	public static String getName(String code) {
		if (code == null) {
			return null;
		}
		for (CheckTypeEnum c : CheckTypeEnum.values()) {
			if (c.getCode().equals(code)) {
				return c.name;
			}
		}
		return null;
	}
	public static String getShortName(String code) {
		if (code == null) {
			return null;
		}
		for (CheckTypeEnum c : CheckTypeEnum.values()) {
			if (c.getCode().equals(code)) {
				return c.shortName;
			}
		}
		return null;
	}

	public static String getThirdOrgName(String code) {
		if (code == null) {
			return null;
		}
		for (CheckTypeEnum c : CheckTypeEnum.values()) {
			if (c.getCode().equals(code)) {
				return c.thirdOrgName;
			}
		}
		return null;
	}
	public static String getThirdOrgNames(String codes,String splitor) {
		if (StringUtils.isEmpty(codes)) {
			return null;
		}
		String[] arrs = codes.split(splitor);
		String names = "";
		for(String a:arrs){
			for (CheckTypeEnum c : CheckTypeEnum.values()) {
				if (c.getCode().equals(a)) {
					names += c.thirdOrgName  + splitor;
				}
			}
		}
		names = names.length() > 1 ? names.substring(0,names.length()-1):names;
		return names;
	}
	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getCode() {
		return code;
	}
	public void setCode(String code) {
		this.code = code;
	}
	public String getShortName() {
		return shortName;
	}
	public void setShortName(String shortName) {
		this.shortName = shortName;
	}
	
}
