package cn.smarthse.modules.health.enums.check;

import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum CheckSourceEnum {

	smarthse("企业端",(byte)1),
	third("服务机构端",(byte)2)
	;

	// 成员变量
	private String name;
	private Byte code;
	// 构造方法

	private CheckSourceEnum(String name, Byte code) {
		this.name = name;
		this.code = code;
	}
	// 普通方法
	public static String getName(Byte code) {
		if (code == null) {
			return null;
		}
		for (CheckSourceEnum c : CheckSourceEnum.values()) {
			if (c.getCode().equals(code)) {
				return c.name;
			}
		}
		return null;
	}

	public static boolean isThird(Byte thirdCode) {
		if(thirdCode==null) return false;
		for (CheckSourceEnum c : CheckSourceEnum.values()) {
			if (c.getCode().equals(thirdCode)) {
				return true;
			}
		}
		return false;
	}
	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Byte getCode() {
		return code;
	}
	public void setCode(Byte code) {
		this.code = code;
	}
}
