package cn.smarthse.modules.health.enums.certificate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 《安全培训合格证书人员类别》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author XiaoYi(肖奕) 
 * @since 2017年11月14日-上午10:47:29
 */
public enum StStaffTypeEnum {
	MAIN(1,"主要负责人"),
	SAFT(2,"分管安全负责人"),
	SAFTPRO(3,"安全生产管理人员"),
	SPECIALOPRE(4,"特种作业人员"),
	;
	
	/**
	 * 人员类别编码
	 */
	private Integer code;
	/**
	 * 类别名称
	 */
	private String name;
	private StStaffTypeEnum(Integer code,String name) {
		this.code = code;
		this.name = name;
	}
	public Integer getCode() {
		return code;
	}
	public void setCode(Integer code) {
		this.code = code;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	
	public static List<Map<String,Object>> getAllValues() {
		StStaffTypeEnum[] tss = StStaffTypeEnum.values();
		List<Map<String,Object>> list= new ArrayList<Map<String,Object>>();
		for(StStaffTypeEnum ts : tss) {
			Map<String,Object> data = new HashMap<String,Object>();
			data.put("code", ts.getCode());
			data.put("name", ts.getName());
			list.add(data);
		}
		return list;
	}
	
	public static String getNameByCode(Integer code) {
		if(code==null) return "";
		StStaffTypeEnum[] tss = StStaffTypeEnum.values();
		for(StStaffTypeEnum ts : tss) {
			if(ts.getCode().equals(code)) {
				return ts.getName();
			}
		}
		return "";
	}
	
}
