package cn.smarthse.modules.health.enums.certificate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 《特种作业操作证作业类别》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author XiaoYi(肖奕) 
 * @since 2017年11月14日-上午10:47:29
 */
public enum SpecialOperationsTypeEnum {
	DGZY(1,"电工作业"),
	HJYEQG(2,"焊接与热切割作业"),
	GCZY(3,"高处作业"),
	ZLYKT(4,"制冷与空调作业"),
	MKAQZY(5,"煤矿安全作业"),
	JSFJSKSAQ(6,"金属非金属矿山安全作业"),
	SSYTRQ(7,"石油天然气安全作业"),
	YJSCAQ(8,"冶金（有色）生产安全作业"),
	WXHXPAQ(9,"危险化学品安全"),
	YHBZAQ(10,"烟花爆竹安全作业"),
	OTHER(11,"安全监管总局认定的其它作业"),
	;
	
	/**
	 * 作业类别编码
	 */
	private Integer code;
	/**
	 * 类别名称
	 */
	private String name;
	private SpecialOperationsTypeEnum(Integer code,String name) {
		this.code = code;
		this.name = name;
	}
	public Integer getCode() {
		return code;
	}
	public void setCode(Integer code) {
		this.code = code;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	
	public static List<Map<String,Object>> getAllValues() {
		SpecialOperationsTypeEnum[] tss = SpecialOperationsTypeEnum.values();
		List<Map<String,Object>> list= new ArrayList<Map<String,Object>>();
		for(SpecialOperationsTypeEnum ts : tss) {
			Map<String,Object> data = new HashMap<String,Object>();
			data.put("code", ts.getCode());
			data.put("name", ts.getName());
			list.add(data);
		}
		return list;
	}
	
	public static String getNameByCode(Integer code) {
		if(code==null) return "";
		SpecialOperationsTypeEnum[] tss = SpecialOperationsTypeEnum.values();
		for(SpecialOperationsTypeEnum ts : tss) {
			if(ts.getCode().equals(code)) {
				return ts.getName();
			}
		}
		return "";
	}
	
}
