package cn.smarthse.modules.health.enums.certificate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 《特种作业操作证证作业类别》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author XiaoYi(肖奕) 
 * @since 2017年11月14日-上午10:47:29
 */
public enum SpecialOperationsDetailTypeEnum {
	GYDGZY(1,1,"高压电工作业"),
	DYDGZY(2,1,"低压电工作业"),
	FBDQZY(3,1,"防爆电气作业"),
	RHHJYRQG(4,2,"熔化焊接与热切割作业"),
	YLHZY(5,2,"压力焊作业"),
	QHZY(6,2,"钎焊作业"),
	DGJSZY(7,3,"登高架设作业"),
	GCAZWHCC(8,3,"高处安装、维护、拆除作业"),
	ZLYKTSBYXCZZY(9,4,"制冷与空调设备运行操作作业"),
	ZLYKTSBAZWXZY(10,4,"制冷与空调设备安装维修作业"),
	MKJXDQZY(11,5,"煤矿井下电气作业"),
	MKJXBPZY(12,5,"煤矿井下爆破作业"),
	MKAQJCJKZY(13,5,"煤矿安全监测监控作业"),
	MKWSJCZY(14,5,"煤矿瓦斯检查作业"),
	MKAQJCZY(15,5,"煤矿安全检查作业"),
	MKYSJCZZY(16,5,"煤矿提升机操作作业"),
	MKCMJCZZY(17,5,"煤矿采煤机（掘进机）操作作业"),
	MKWSCCZY(18,5,"煤矿瓦斯抽采作业"),
	MKFTZY(19,5,"煤矿防突作业"),
	MKTFSZY(20,5,"煤矿探放水作业"),
	JSFJSKJTFZY(21,6,"金属非金属矿井通风作业"),
	WKZY(22,6,"尾矿作业"),
	JSFJSKSAQJCZY(23,6,"金属非金属矿山安全检查作业"),
	JSFJSKSTSJCZZY(24,6,"金属非金属矿山提升机操作作业"),
	JSFJSKSZZZY(25,6,"金属非金属矿山支柱作业"),
	JSFJSKSJXDQZY(26,6,"金属非金属矿山井下电气作业"),
	JSFJSKSPSZY(27,6,"金属非金属矿山排水作业"),
	JSFJSKSBPZY(28,6,"金属非金属矿山爆破作业"),
	SZZY(29,7,"司钻作业"),
	MQZY(30,8,"煤气作业"),
	GQJGQHGYZY(31,9,"光气及光气化工艺作业"),
	LJDJGYZY(32,9,"氯碱电解工艺作业"),
	LHGYZY(33,9,"氯化工艺作业"),
	XHGYZY(34,9,"硝化工艺作业"),
	HCAGYZY(35,9,"合成氨工艺作业"),
	LJLHGYZY(36,9,"裂解（裂化）工艺作业"),
	FHGYZY(37,9,"氟化工艺作业"),
	JQGYZY(38,9,"加氢工艺作业"),
	ZDHGYZY(39,9,"重氮化工艺作业"),
	YHGYZY(40,9,"氧化工艺作业"),
	GYHGYZY(41,9,"过氧化工艺作业"),
	AJHGYZY(42,9,"氨基化工艺作业"),
	HHGYZY(43,9,"磺化工艺作业"),
	JHGYZY(44,9,"聚合工艺作业"),
	WJGYZY(45,9,"烷基化工艺作业"),
	HGZDHKZYBZY(46,9,"化工自动化控制仪表作业"),
	YHYZZZY(47,10,"烟火药制造作业"),
	HHYZZZY(48,10,"黑火药制造作业"),
	YHXZZZY(49,10,"引火线制造作业"),
	YHBZCPSYZY(50,10,"烟花爆竹产品涉药作业"),
	YHBZCCZY(51,10,"烟花爆竹储存作业")
	;
	
	/**
	 * 作业类别编码
	 */
	private Integer code;
	/**
	 * 上级类别类别编码
	 */
	private Integer fcode;
	/**
	 * 类别名称
	 */
	private String name;
	private SpecialOperationsDetailTypeEnum(Integer code,Integer fcode,String name) {
		this.code = code;
		this.fcode = fcode;
		this.name = name;
	}
	public Integer getCode() {
		return code;
	}
	public void setCode(Integer code) {
		this.code = code;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	
	public Integer getFcode() {
		return fcode;
	}
	public void setFcode(Integer fcode) {
		this.fcode = fcode;
	}
	public static List<Map<String,Object>> getAllValues() {
		SpecialOperationsDetailTypeEnum[] tss = SpecialOperationsDetailTypeEnum.values();
		List<Map<String,Object>> list= new ArrayList<Map<String,Object>>();
		for(SpecialOperationsDetailTypeEnum ts : tss) {
			Map<String,Object> data = new HashMap<String,Object>();
			data.put("code", ts.getCode());
			data.put("fcode", ts.getFcode());
			data.put("name", ts.getName());
			list.add(data);
		}
		return list;
	}
	
	public static String getNameByCode(Integer code) {
		if(code==null) return "";
		SpecialOperationsDetailTypeEnum[] tss = SpecialOperationsDetailTypeEnum.values();
		for(SpecialOperationsDetailTypeEnum ts : tss) {
			if(ts.getCode().equals(code)) {
				return ts.getName();
			}
		}
		return "";
	}
	public static List<Map<String,Object>> getListByFcode(Integer fcode) {
		SpecialOperationsDetailTypeEnum[] tss = SpecialOperationsDetailTypeEnum.values();
		List<Map<String,Object>> list= new ArrayList<Map<String,Object>>();
		for(SpecialOperationsDetailTypeEnum ts : tss) {
			if(ts.getFcode().equals(fcode)){
				Map<String,Object> data = new HashMap<String,Object>();
				data.put("code", ts.getCode());
				data.put("fcode", ts.getFcode());
				data.put("name", ts.getName());
				list.add(data);
			}
		}
		return list;
	}
	
}
