package cn.smarthse.modules.health.enums.certificate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 《特种设备作业人员证作业类别》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author XiaoYi(肖奕) 
 * @since 2017年11月14日-上午10:47:29
 */
public enum SpecialEquipOperationsTypeEnum {
	TZSBXGGL(1,"特种设备安全管理"),
	GLZY(2,"锅炉作业"),
	YLRQZY(3,"压力容器作业"),
	QPZY(4,"气瓶作业"),
	//YLGDZY(5,"压力管道作业"),
	DTZY(6,"电梯作业"),
	QZJXZY(7,"起重机械作业"),
	KYSDZY(8,"客运索道作业"),
	DXYLSSZY(9,"大型游乐设施作业"),
	CNZYJDCL(10,"场（厂）内专用机动车辆作业"),
	AQFJWXZY(11,"安全附件维修作业"),
	TZSBHJZY(12,"特种设备焊接作业")
	;
	
	/**
	 * 作业类别编码
	 */
	private Integer code;
	/**
	 * 类别名称
	 */
	private String name;
	private SpecialEquipOperationsTypeEnum(Integer code,String name) {
		this.code = code;
		this.name = name;
	}
	public Integer getCode() {
		return code;
	}
	public void setCode(Integer code) {
		this.code = code;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	
	public static List<Map<String,Object>> getAllValues() {
		SpecialEquipOperationsTypeEnum[] tss = SpecialEquipOperationsTypeEnum.values();
		List<Map<String,Object>> list= new ArrayList<Map<String,Object>>();
		for(SpecialEquipOperationsTypeEnum ts : tss) {
			Map<String,Object> data = new HashMap<String,Object>();
			data.put("code", ts.getCode());
			data.put("name", ts.getName());
			list.add(data);
		}
		return list;
	}
	
	public static String getNameByCode(Integer code) {
		if(code==null) return "";
		SpecialEquipOperationsTypeEnum[] tss = SpecialEquipOperationsTypeEnum.values();
		for(SpecialEquipOperationsTypeEnum ts : tss) {
			if(ts.getCode().equals(code)) {
				return ts.getName();
			}
		}
		return "";
	}
	
}
