package cn.smarthse.modules.health.enums.certificate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 《特种设备作业人员证作业类别》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author XiaoYi(肖奕) 
 * @since 2017年11月14日-上午10:47:29
 */
public enum SpecialEquipOperationsDetailTypeEnum {
	TZSBAQGLFZR(1,1,"特种设备安全管理"),
	/*TZSBZLGLFZR(2,1,"特种设备质量管理负责人"),
	GLYALRQYLGDAQGL(3,1,"锅炉压力容器压力管道安全管理"),
	DTANGL(4,1,"电梯安全管理"),
	QZJXAQGL(5,1,"起重机械安全管理"),
	KYSDAQGL(6,1,"客运索道安全管理"),
	DXYLSSAQGL(7,1,"大型游乐设施安全管理"),
	CNZYJDCLANGL(8,1,"场（厂）内专用机动车辆安全管理"),*/
	YJGLSL(9,2,"工业锅炉司炉"),
	EJGLSL(10,2,"电站锅炉司炉"),
	//SJGLSL(11,2,"三级锅炉司炉"),
	YJGLSZCL(12,2,"锅炉水处理"),
	/*EJGLSZCL(13,2,"二级锅炉水质处理"),
	GLNXXZY(14,2,"锅炉能效作业"),*/
	GDSYLRQCZ(15,3,"快开门式压力容器操作"),
	YDSYLRQCZ(16,3,"移动式压力容器操作"),
	YCWHBY(17,3,"氧舱维护保养"),
	YJQTQPCZ(18,4,"气瓶充装"),
	/*YTQTQPCZ(19,4,"液体气体气瓶充装"),
	RJYQQPCZ(20,4,"溶解乙炔气瓶充装"),
	YHSYQPCZ(21,4,"液化石油气瓶充装"),
	CYQPCZ(22,4,"车用气瓶充装"),*/
	/*YLGDXJWH(23,5,"压力管道巡检维护"),
	DYFD(24,5,"带压封堵"),
	DYMF(25,5,"带压密封"),*/
	DTJXAZWX(26,6,"电梯修理"),
	/*DTDQAZWX(27,6,"电梯电气安装维修"),
	DTSJ(28,6,"电梯司机"),*/
	/*QZJXJXAZWX(29,7,"起重机械机械安装维修"),
	QZJXDQAZWX(30,7,"起重机械电气安装维修"),*/
	QZJXZH(31,7,"起重机械指挥"),
	QMSQZJSJ(32,7,"起重机司机"),
	/*TSQZJSJ(33,7,"塔式起重机司机"),
	MZSQZJSJ(34,7,"门座式起重机司机"),
	LSSQZJSJ(35,7,"缆索式起重机司机"),
	LDSQZJSJ(36,7,"流动式起重机司机"),
	SJJSJ(37,7,"升降机司机"),
	JXSTCSBSJ(38,7,"机械式停车设备司机"),*/
	//KYSDAZ(39,8,"客运索道安装"),
	KYSDWX(40,8,"客运索道修理"),
	KYSDSJ(41,8,"客运索道司机"),
	//KYSDBS(42,8,"客运索道编索"),
	//DXYLSSAZ(43,9,"大型游乐设施安装"),
	DXYLSSWX(44,9,"大型游乐设施维修"),
	DXYLSSCZ(45,9,"大型游乐设施操作"),
	//SSYLSSCZYWX(46,9,"水上游乐设施操作与维修"),
	//CLWX(47,10,"车辆维修"),
	CCSJ(48,10,"叉车司机"),
	//BYCQYCTDCSJ(49,10,"搬运车牵引车推顶车司机"),
	NRGGCSJ(50,10,"观光车和观光列车司机"),
	//XDCGGCSJ(51,10,"蓄电池观光车司机"),
	AQFJY(52,11,"安全阀检验"),
	//AQFWX(53,11,"安全阀维修"),
	JSHJCZ(54,12,"金属焊接操作"),
	FJSHJCZ(55,12,"非金属焊接操作")
	;
	
	/**
	 * 作业类别编码
	 */
	private Integer code;
	/**
	 * 上级类别类别编码
	 */
	private Integer fcode;
	/**
	 * 类别名称
	 */
	private String name;
	private SpecialEquipOperationsDetailTypeEnum(Integer code,Integer fcode,String name) {
		this.code = code;
		this.fcode = fcode;
		this.name = name;
	}
	public Integer getCode() {
		return code;
	}
	public void setCode(Integer code) {
		this.code = code;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	
	public Integer getFcode() {
		return fcode;
	}
	public void setFcode(Integer fcode) {
		this.fcode = fcode;
	}
	public static List<Map<String,Object>> getAllValues() {
		SpecialEquipOperationsDetailTypeEnum[] tss = SpecialEquipOperationsDetailTypeEnum.values();
		List<Map<String,Object>> list= new ArrayList<Map<String,Object>>();
		for(SpecialEquipOperationsDetailTypeEnum ts : tss) {
			Map<String,Object> data = new HashMap<String,Object>();
			data.put("code", ts.getCode());
			data.put("fcode", ts.getFcode());
			data.put("name", ts.getName());
			list.add(data);
		}
		return list;
	}
	
	public static String getNameByCode(Integer code) {
		if(code==null) return "";
		SpecialEquipOperationsDetailTypeEnum[] tss = SpecialEquipOperationsDetailTypeEnum.values();
		for(SpecialEquipOperationsDetailTypeEnum ts : tss) {
			if(ts.getCode().equals(code)) {
				return ts.getName();
			}
		}
		return "";
	}
	public static List<Map<String,Object>> getListByFcode(Integer fcode) {
		SpecialEquipOperationsDetailTypeEnum[] tss = SpecialEquipOperationsDetailTypeEnum.values();
		List<Map<String,Object>> list= new ArrayList<Map<String,Object>>();
		for(SpecialEquipOperationsDetailTypeEnum ts : tss) {
			if(ts.getFcode().equals(fcode)){
				Map<String,Object> data = new HashMap<String,Object>();
				data.put("code", ts.getCode());
				data.put("fcode", ts.getFcode());
				data.put("name", ts.getName());
				list.add(data);
			}
		}
		return list;
	}
	
}
