package cn.smarthse.modules.health.enums.certificate;


import cn.hutool.core.util.StrUtil;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 《人员证书证书默认名称》
 *
 * @author XiaoYi(肖奕)
 * @Project: smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @since 2021年12月29日-上午9:49:26
 */
@AllArgsConstructor
@Getter
public enum CertificateStaffNameTypeEnum {

    MainTrain("企业主要负责人证书", 12L, "企业主要负责人", "01", "200001"),
    ManaTrain("职业卫生管理人员证书", 13L, "职业卫生管理人员", "02", "200002"),
    SpeacialOperat("放射防护知识培训合格证书", 14L, "放射防护知识培训", null, null),
    SpeacialEquipOp("辐射安全与防护培训合格证书", 15L, "辐射安全与防护", null, null);

    private final String name;
    private final Long id;
    private final String nameType;
    /**
     * 证书类识别号
     */
    private final String identification;
    /**
     * 在线培训中的value
     */
    private final String onlineTrainValue;

    public static String getNameById(Long id) {
        if (id == null) return "";
        CertificateStaffNameTypeEnum[] tss = CertificateStaffNameTypeEnum.values();
        for (CertificateStaffNameTypeEnum ts : tss) {
            if (ts.getId().equals(id)) {
                return ts.getName();
            }
        }
        return "";
    }

    public static String getNameTypeById(Long id) {
        if (id == null) return "";
        CertificateStaffNameTypeEnum[] values = CertificateStaffNameTypeEnum.values();
        for (CertificateStaffNameTypeEnum ts : values) {
            if (ts.getId().equals(id)) {
                return ts.getNameType();
            }
        }
        return "";
    }

    public static String getOnlineTrainValueById(Long id) {
        if (id == null) return "";
        CertificateStaffNameTypeEnum[] values = CertificateStaffNameTypeEnum.values();
        for (CertificateStaffNameTypeEnum ts : values) {
            if (ts.getId().equals(id)) {
                return ts.getOnlineTrainValue();
            }
        }
        return "";
    }

    public static String getIdentificationById(Long id) {
        if (id == null) return "";
        CertificateStaffNameTypeEnum[] values = CertificateStaffNameTypeEnum.values();
        for (CertificateStaffNameTypeEnum ts : values) {
            if (ts.getId().equals(id)) {
                return ts.getIdentification();
            }
        }
        return "";
    }

    public static String getNameTypesByIds(String ids) {
        if (StrUtil.isBlank(ids)) return "";

        List<Long> idList = Arrays.stream(ids.split(","))
                .map(id -> Long.parseLong(id.trim()))
                .collect(Collectors.toList());

        StringBuilder nameTypes = new StringBuilder();
        for (Long id : idList) {
            for (CertificateStaffNameTypeEnum ts : CertificateStaffNameTypeEnum.values()) {
                if (ts.getId().equals(id)) {
                    if (nameTypes.length() > 0) {
                        nameTypes.append("、");
                    }
                    nameTypes.append(ts.getNameType());
                }
            }
        }
        return nameTypes.toString();
    }

}
