package cn.smarthse.modules.health.enums.certificate;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 人员证书清单-数据来源枚举
 *
 * @author 覃浩云 1770126791@qq.com
 * @date: 2023/5/5 9:49
 */
@AllArgsConstructor
@Getter
public enum CertificateStaffDetailDataSourceEnum {

    /**
     * null、1、2、4 算其它来源
     */
    COMPANY("企业端新增", 1),
    ORGANIZATION("机构端上报", 2),
    ONLINE("在线培训", 3),
    OTHER("培训系统导入的数据", 4), // 不知道
    WANDA("万达仓-杭州培训", 5),
    OFFLINE("线下培训", 6),
    ;

    private final String name;
    private final Integer value;

    public static String getNameByValue(Integer value) {
        if (value == null) {
            return "";
        }
        CertificateStaffDetailDataSourceEnum[] values = CertificateStaffDetailDataSourceEnum.values();
        for (CertificateStaffDetailDataSourceEnum certificateStaffDetailDataSourceEnum : values) {
            if (certificateStaffDetailDataSourceEnum.getValue().equals(value)) {
                return certificateStaffDetailDataSourceEnum.getName();
            }
        }
        return "";
    }

}
