package cn.smarthse.modules.health.enums.certificate;

/**
 * @description: 人员证书清单-审核状态枚举
 * @author 覃浩云 1770126791@qq.com
 * @date 2023/5/5 9:49
 */
public enum ApprovalStatusEnum {

	//0-草稿 1-已通过 2-被退回 3-待审核 4-无需审核 5-已终止
	DRAFT("草稿", (byte)0),
	PASSED("已通过", (byte)1),
	REFUND("被退回", (byte)2),
	WAITAPPROVAL("待审核", (byte)3),
	NONEEDAPPROVAL("无需审核", (byte)4),
	TERMINATED("已终止", (byte)5);

	private final String name;
	private final Byte value;

	ApprovalStatusEnum(String name, Byte value) {
		this.name = name;
		this.value = value;
	}

	public String getName() {
		return name;
	}
	public Byte getValue() {
		return value;
	}

	public static String getNameByValue(Byte value) {
		if (value == null) {
			return "";
		}
		ApprovalStatusEnum[] values = ApprovalStatusEnum.values();
		for (ApprovalStatusEnum certificateStaffDetailDataSourceEnum : values) {
			if (certificateStaffDetailDataSourceEnum.getValue().equals(value)) {
				return certificateStaffDetailDataSourceEnum.getName();
			}
		}
		return "";
	}

}
