package cn.smarthse.modules.health.enums.archive;

import cn.smarthse.common.util.StringUtils;

/**
 * 檢測結果特殊字符（結果前面的字符）和頁面上不一樣的地方是0，則爲空
 * 《》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author Horsy(何世壹) [hsy@smarthse.cn]
 * @since 2017年10月9日-下午2:00:41
 */
public enum HarmFactorResultCollectSpecialCharacterEnum {
	ROD("","空",0), LT("＜","小于",1),LTE("≤","小于等于",2),FW_WL("～","全角波浪线",3),HW_WL("~","半角波浪线",4);
	
	private HarmFactorResultCollectSpecialCharacterEnum(String character,String desc,Integer code){
		this.character = character;
		this.desc = desc;
		this.code = code;
	}
	
	public static String getCharByCodeStr(String code){
		if(StringUtils.isEmpty(code)){
			return code;
		}
		if(StringUtils.isInteger(code)){
			return getCharByCode(Integer.valueOf(code));
		}
		return code;
	}
	
	public static String getCharByCode(Integer code){
		if(code == null){
			return code+"";
		}
		for(HarmFactorResultCollectSpecialCharacterEnum specialChar:HarmFactorResultCollectSpecialCharacterEnum.values()){
			if(specialChar.getCode().equals(code)){
				return specialChar.getCharacter();
			}
		}
		return code+"";
		
	}
	
	private String character;//字符
	
	private String desc; //描述
	
	private Integer code;//编号
	
	public String getCharacter() {
		return character;
	}
	
	public String getDesc() {
		return desc;
	}
    
	public Integer getCode() {
		
		return code;
	}
	
}
