/**
 * 
 */
package cn.smarthse.modules.health.enums.archive;

import java.util.ArrayList;
import java.util.List;

/**
 * 《档案类型定义》
 * 1-三同时\n            
 * 2-职业卫生管理档案\n            
 * 3-职业卫生宣传培训档案\n            
 * 4-职业病危害因素监测与检测评价档案\n            
 * 5-用人单位职业健康监护管理档案\n            
 * 6-劳动者个人职业健康监护档案
 * 
 * @Project:  smarthse-facade1.0
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-9-1-下午4:51:06
 */
public enum ArchiveType {
	Archive1("建设项目职业卫生“三同时“档案", (byte)1, "tsProjectArchiveService", "/archive/tsproject"),	
	Archive2("职业卫生管理档案", (byte)2, "occHealthArchiveService", "/archive/doc2"),	
	Archive3("职业卫生宣传培训档案", (byte)3, "trainPlanArchiveService", "/archive/doc3"),
	Archive4("职业病危害因素监测与检测评价档案", (byte)4, "harmFactorTestArchiveService", "/archive/doc4"),
	Archive5("用人单位职业健康监护管理档案",(byte)5, "phcPhysicalCompanyServiceImpl", "/archive/doc5"),
	Archive6("劳动者个人职业健康监护档案",(byte)6, "personalPHCArhiveService", "/archive/doc6"),
	; 
	
		// 成员变量
		private String name;						//档案名称
		private byte type;						//档案类型
		private String serviceBean;			//档案Service Bean名称
		private String url;							//档案业务地址
		// 构造方法

		private ArchiveType(String name, byte type, String serviceBean, String url) {
			this.name = name;
			this.type = type;
			this.serviceBean = serviceBean;
			this.url = url;
		}
		
		public static List<ArchiveType> getArchiveListHasYear(){
			List<ArchiveType> list = new ArrayList <ArchiveType>();
			list.add(ArchiveType.Archive2);
			list.add(ArchiveType.Archive3);
			list.add(ArchiveType.Archive4);
			list.add(ArchiveType.Archive5);
			return list;
		}
		
		/**
		 * 根据type获取档案类型
		 * 
		 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
		 * @author JannyShao(邵建义) [ksgameboy@qq.com]
		 * @since 2017-9-4-下午12:57:28
		 * @param type
		 * @return
		 */
		public static ArchiveType getArchiveType(byte type) {
			for (ArchiveType c : ArchiveType.values()) {
				if (c.getType() == type) {
					return c;
				}
			}
			return null;
		}
		
		
		// get set 方法
		public String getName() {
			return name;
		}
		public void setName(String name) {
			this.name = name;
		}


		/**
		 * @return the type
		 */
		public byte getType() {
			return type;
		}


		/**
		 * @param type the type to set
		 */
		public void setType(byte type) {
			this.type = type;
		}


		/**
		 * @return the serviceBean
		 */
		public String getServiceBean() {
			return serviceBean;
		}


		/**
		 * @param serviceBean the serviceBean to set
		 */
		public void setServiceBean(String serviceBean) {
			this.serviceBean = serviceBean;
		}

		/**
		 * @return the url
		 */
		public String getUrl() {
			return url;
		}

		/**
		 * @param url the url to set
		 */
		public void setUrl(String url) {
			this.url = url;
		}
		
		
		
		
		
		
}
