/**
 * 
 */
package cn.smarthse.modules.health.enums.archive;

/**
 * 《档案生成档案状态定义》
 * 0-待生成,1-正在生成,2-已生成3-生成失败?
 * 
 * @Project:  smarthse-facade1.0
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-9-4-上午10:40:59
 */
public enum ArchiveGeneratorState {
	none("无",(byte)-1),

	/**
	 * 待生成
	 */
	generat("待生成",(byte) 0),
	
	/**
	 * 正在生成
	 */
	generating("正在生成",(byte) 1),
	/**
	 * 已生成
	 */
	generat_success("已生成",(byte) 2),
	/**
	 * 生成失败
	 */
	generat_fail("生成失败",(byte)3),
	;
	
		// 成员变量
		private String name;
		private byte value;
		// 构造方法
		
		private ArchiveGeneratorState(String name, byte value) {
			this.name = name;
			this.value = value;
		}

		/**
		 * @return the name
		 */
		public String getName() {
			return name;
		}

		/**
		 * @param name the name to set
		 */
		public void setName(String name) {
			this.name = name;
		}

		/**
		 * @return the value
		 */
		public byte getValue() {
			return value;
		}

		/**
		 * @param value the value to set
		 */
		public void setValue(byte value) {
			this.value = value;
		}
}
