package cn.smarthse.modules.health.enums.accident;

import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum LevelEnum {
	//1、一般事故 2、较大事故 3、重大事故 4、特别重大事故
	level1("一般事故",(byte)1),	
	level2("较大事故",(byte)2),	
	level3("重大事故",(byte)3),
	level4("特别重大事故",(byte)4),
	; 
	
	// 成员变量
	private String name;
	private Byte code;
	// 构造方法

	private LevelEnum(String name, Byte code) {
		this.name = name;
		this.code = code;
	}
	// 普通方法
	public static String getName(Byte code) {
		if (code == null) {
			return null;
		}
		for (LevelEnum c : LevelEnum.values()) {
			if (c.getCode().byteValue()==code.byteValue()) {
				return c.name;
			}
		}
		return null;
	}
	
	
	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Byte getCode() {
		return code;
	}
	public void setCode(Byte code) {
		this.code = code;
	}
}
