package cn.smarthse.modules.health.entity.work.weChat;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Table(name = "wechat_send_record")
public class WechatSendRecord implements Serializable {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 平台用户id
     */
    @Column(name = "plant_user_id")
    private Long plantUserId;

    /**
     * 推送时间
     */
    @Column(name = "send_time")
    private Date sendTime;

    /**
     * 推送返回状态
     */
    private Integer status;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 发送消息
     */
    @Column(name = "send_message")
    private String sendMessage;
    
    @Transient
    private List<WechatSendLog> logs;

    private static final long serialVersionUID = 1L;

    /**
     * @return id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取平台用户id
     *
     * @return plant_user_id - 平台用户id
     */
    public Long getPlantUserId() {
        return plantUserId;
    }

    /**
     * 设置平台用户id
     *
     * @param plantUserId 平台用户id
     */
    public void setPlantUserId(Long plantUserId) {
        this.plantUserId = plantUserId;
    }

    /**
     * 获取推送时间
     *
     * @return send_time - 推送时间
     */
    public Date getSendTime() {
        return sendTime;
    }

    /**
     * 设置推送时间
     *
     * @param sendTime 推送时间
     */
    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

   
    public Integer getStatus() {
        return status;
    }

   
    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取发送消息
     *
     * @return send_message - 发送消息
     */
    public String getSendMessage() {
        return sendMessage;
    }

    /**
     * 设置发送消息
     *
     * @param sendMessage 发送消息
     */
    public void setSendMessage(String sendMessage) {
        this.sendMessage = sendMessage == null ? null : sendMessage.trim();
    }

	public List<WechatSendLog> getLogs() {
		return logs;
	}

	public void setLogs(List<WechatSendLog> logs) {
		this.logs = logs;
	}
    
}