package cn.smarthse.modules.health.entity.work.weChat;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "wechat_send_log")
public class WechatSendLog implements Serializable {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 业务id
     */
    @Column(name = "bus_id")
    private Long busId;

    /**
     * 推送记录id
     */
    @Column(name = "record_id")
    private Long recordId;

    /**
     * 业务类型
     */
    @Column(name = "bus_type")
    private Byte busType;

    /**
     * 推送时间
     */
    @Column(name = "send_time")
    private Date sendTime;

    /**
     * 状态（-1、推送失败 1、已推送 2、已忽略 3、已处理）
     */
    private Byte status;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    private static final long serialVersionUID = 1L;
    
    @Transient
    private Long plantUserId;

    /**
     * @return id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取业务id
     *
     * @return bus_id - 业务id
     */
    public Long getBusId() {
        return busId;
    }

    /**
     * 设置业务id
     *
     * @param busId 业务id
     */
    public void setBusId(Long busId) {
        this.busId = busId;
    }

    /**
     * 获取推送记录id
     *
     * @return record_id - 推送记录id
     */
    public Long getRecordId() {
        return recordId;
    }

    /**
     * 设置推送记录id
     *
     * @param recordId 推送记录id
     */
    public void setRecordId(Long recordId) {
        this.recordId = recordId;
    }

    /**
     * 获取业务类型
     *
     * @return bus_type - 业务类型
     */
    public Byte getBusType() {
        return busType;
    }

    /**
     * 设置业务类型
     *
     * @param busType 业务类型
     */
    public void setBusType(Byte busType) {
        this.busType = busType;
    }

    /**
     * 获取推送时间
     *
     * @return send_time - 推送时间
     */
    public Date getSendTime() {
        return sendTime;
    }

    /**
     * 设置推送时间
     *
     * @param sendTime 推送时间
     */
    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    /**
     * 获取状态（1、已推送 2、已忽略 3、已处理）
     *
     * @return status - 状态（1、已推送 2、已忽略 3、已处理）
     */
    public Byte getStatus() {
        return status;
    }

    /**
     * 设置状态（1、已推送 2、已忽略 3、已处理）
     *
     * @param status 状态（1、已推送 2、已忽略 3、已处理）
     */
    public void setStatus(Byte status) {
        this.status = status;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

	public Long getPlantUserId() {
		return plantUserId;
	}

	public void setPlantUserId(Long plantUserId) {
		this.plantUserId = plantUserId;
	}
    
}