package cn.smarthse.modules.health.entity.work.trusteeship;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 第三方托管服务机构工作信息
 *
 * @author 吴嘉诚
 * @date 2022/4/15 14:45
 * @desc
 */
@Table(name = "trusteeship_service_org_info")
public @Data
class TrusteeshipServiceOrgInfo implements Serializable {

    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    @Column(name = "trusteeship_org_id")
    private Long trusteeshipOrgId;      //托管机构ID

    @Column(name = "org_name")
    private String orgName;             //机构名称

    private Integer year;               //年份

    private Integer quarter;            //季度 1：第一季度  2：第二季度  3：第三季度  4：第四季度

    @Column(name = "area_id")
    private Long areaId;                //区域ID

    @Transient
    private String areaName;            //区域名称

    @Column(name = "execution_time")
    private Date executionTime;         //定时器执行时间

    @Column(name = "num_of_service")
    private Integer numOfService;    //需服务数

    @Column(name = "num_of_completed_service")
    private Integer numOfCompletedService;  //已服务数

    private Byte status;                //核查工作状态  1 已完成、2 进行中、3 未完成、4 未开始

    @Column(name = "create_Date")
    private Date createDate;            //创建时间

}
