package cn.smarthse.modules.health.entity.work.trusteeship;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 第三方托管核查风险监测(经营状态)中间表
 *
 * @TableName trusteeship_risk
 */
@Table(name = "trusteeship_risk")
public @Data class TrusteeshipRisk implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 托管核查工作信息ID
     */
    @Column(name = "trusteeship_info_id")
    private Long trusteeshipInfoId;

    /**
     * 经营状态（4-已关闭，5-暂停营业）
     */
    private Integer status;

    /**
     * 是否已确认（0-未确认，1-已确认）
     */
    private Integer confirm;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;
}