package cn.smarthse.modules.health.entity.work.trusteeship;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Table(name = "trusteeship_org")
public @Data class TrusteeshipOrg implements Serializable {

    private static final long serialVersionUID = -444880682082778434L;
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    @Column(name = "org_id")
    private Long orgId;

    /**
     * 区分企业还是机构（1：企业 2：机构）
     */
    private Byte type;
    @Column(name = "org_name")
    private String orgName;

    private Integer year;

    @Column(name = "area_id")
    //private Long areaId;
    private String areaId;

    /**
     * 状态（0 正常，1 禁用)
     */
    private Byte status;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;
}