package cn.smarthse.modules.health.entity.work.trusteeship;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 第三方托管服务管理档案表
 * @author 吴嘉诚
 * @date 2022/6/8 12:35
 * @desc
 */
@Table(name = "trusteeship_manager")
public @Data
class TrusteeshipManager implements Serializable {

    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    private Integer year;   //年份

    @Column(name = "quarter_one_org")
    private Integer quarterOneOrg;  //第一季度服务机构数

    @Column(name = "quarter_one_finished_org")
    private Integer quarterOneFinishedOrg;  //第一季度已完成服务机构

    @Column(name = "quarter_one_unfinished_org")
    private Integer quarterOneUnfinishedOrg;  //第一季度未完成服务机构

    @Column(name = "quarter_two_org")
    private Integer quarterTwoOrg;

    @Column(name = "quarter_two_finished_org")
    private Integer quarterTwoFinishedOrg;

    @Column(name = "quarter_two_unfinished_org")
    private Integer quarterTwoUnfinishedOrg;

    @Column(name = "quarter_three_org")
    private Integer quarterThreeOrg;

    @Column(name = "quarter_three_finished_org")
    private Integer quarterThreeFinishedOrg;

    @Column(name = "quarter_three_unfinished_org")
    private Integer quarterThreeUnfinishedOrg;

    @Column(name = "quarter_four_org")
    private Integer quarterFourOrg;

    @Column(name = "quarter_four_finished_org")
    private Integer quarterFourFinishedOrg;

    @Column(name = "quarter_four_unfinished_org")
    private Integer quarterFourUnfinishedOrg;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

}
