package cn.smarthse.modules.health.entity.work.trusteeship;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Table(name = "trusteeship_info_detail")
public @Data
class TrusteeshipInfoDetail implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    @Column(name = "trusteeship_info_id")
    private Long trusteeshipInfoId;




    /**
     * 核查项
     */
    @Column(name = "check_item_id")
    private Long checkItemId;

    /**
     * 核查结果（0 未选择,1 未核查，2 符合，3 不符合，4 合理缺项)
     */

    private Byte result;

    private String description;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    @Transient
    private String checkItemName;

    @Transient
    private String reformStatus;

    @Transient
    private Long reformId;




}