package cn.smarthse.modules.health.entity.work.trusteeship;

import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Table(name = "trusteeship_info")
public @Data
class TrusteeshipInfo implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    @Column(name = "trusteeship_org_id")
    private Long trusteeshipOrgId;

    private Integer year;

    private Integer quarter;

    private Long cid;

    /**
     * 核查时间
     */
    @Column(name = "check_time")
    private Date checkTime;

    /**
     * 核查人
     */
    @Column(name = "check_person")
    private String checkPerson;

    /**
     * 核查状态（1 未开始，2 已提交，3 未完成/进行中，4 被退回，5 数据补录)
     */
    private Byte status;

    /**
     * 核查结论（1 机构指导整改  2 上报行政主管部门）
     */
    private Byte result;

    private String description;

    /**
     * 单位联系人
     */
    private String contacts;

    /**
     * 联系电话
     */
    private String telephone;


    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 图像资料
     */
    @Column(name = "file_str")
    private String fileStr;

    @Transient
    private List<SysFileModel> fileList;

    @Transient
    private String companyName;

    @Transient
    private String orgName;

    //不符合项
    @Transient
    private Integer unConformityNum=0;
    //合理缺项
    @Transient
    private Integer reasonableNum=0;

    //未检查项
    @Transient
    private Integer unCheckNum=0;

    //待整改数
    @Transient
    private Integer toReformNum=0;
    //待验收数
    @Transient
    private Integer toAcceptanceNum=0;
    //工作地址
    @Transient
    private String address;



}