package cn.smarthse.modules.health.entity.work.train;

import cn.smarthse.common.util.validation.DataValida;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Table(name = "train_summarize")
public class TrainSummarize implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 总结编号
     */
    private String no;

    /**
     * 总结名称
     */
    private String name;

    /**
     * 总结年度
     */
    private Integer year;

    /**
     * 工作分析总结
     */
    @DataValida(nullAble=true,maxLength="2000",name="工作分析总结")
    private String info;

    /**
     * 年度培训经费
     */
    private BigDecimal outlay;

    /**
     * 存在的问题
     */
    @DataValida(nullAble=true,maxLength="2000",name="存在的问题")
    private String problem;

    /**
     * 改进和建议
     */
    @DataValida(nullAble=true,maxLength="2000",name="改进和建议")
    private String advise;

    /**
     * 备注
     */
    @DataValida(nullAble=true,maxLength="2000",name="备注")
    private String remark;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 是否完成（0未完成 1已完成）
     */
    @Column(name = "is_finish")
    private Boolean isFinish;
    /**
     * 组织部门id
     */
    @Column(name = "org_id")
    private String orgId;
   
  
    public String getOrgId() {
		return orgId;
	}

	public void setOrgId(String orgId) {
		this.orgId = orgId;
	}

	/**
     * 创建人姓名
     */
    @Transient
    private String createName;
    /**
     * 附件
     */
    @Transient
    private List<TrainPaperFile> fileList;
    /**
     * 预算
     */
    @Transient
    private String budget;
   
    private static final long serialVersionUID = 1L;
    
    /**
     * 附件名
     */
    @Transient
    private String fileName;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取总结编号
     *
     * @return no - 总结编号
     */
    public String getNo() {
        return no;
    }

    /**
     * 设置总结编号
     *
     * @param no 总结编号
     */
    public void setNo(String no) {
        this.no = no == null ? null : no.trim();
    }

    /**
     * 获取总结名称
     *
     * @return name - 总结名称
     */
    public String getName() {
        return name;
    }

    /**
     * 设置总结名称
     *
     * @param name 总结名称
     */
    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    /**
     * 获取总结年度
     *
     * @return year - 总结年度
     */
    public Integer getYear() {
        return year;
    }

    /**
     * 设置总结年度
     *
     * @param year 总结年度
     */
    public void setYear(Integer year) {
        this.year = year;
    }

    /**
     * 获取工作分析总结
     *
     * @return info - 工作分析总结
     */
    public String getInfo() {
        return info;
    }

    /**
     * 设置工作分析总结
     *
     * @param info 工作分析总结
     */
    public void setInfo(String info) {
        this.info = info == null ? null : info.trim();
    }

    /**
     * 获取年度培训经费
     *
     * @return outlay - 年度培训经费
     */
    public BigDecimal getOutlay() {
        return outlay;
    }

    /**
     * 设置年度培训经费
     *
     * @param outlay 年度培训经费
     */
    public void setOutlay(BigDecimal outlay) {
        this.outlay = outlay;
    }

    /**
     * 获取存在的问题
     *
     * @return problem - 存在的问题
     */
    public String getProblem() {
        return problem;
    }

    /**
     * 设置存在的问题
     *
     * @param problem 存在的问题
     */
    public void setProblem(String problem) {
        this.problem = problem == null ? null : problem.trim();
    }

    /**
     * 获取改进和建议
     *
     * @return advise - 改进和建议
     */
    public String getAdvise() {
        return advise;
    }

    /**
     * 设置改进和建议
     *
     * @param advise 改进和建议
     */
    public void setAdvise(String advise) {
        this.advise = advise == null ? null : advise.trim();
    }

    /**
     * 获取备注
     *
     * @return remark - 备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 设置备注
     *
     * @param remark 备注
     */
    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取是否完成（0未完成 1已完成）
     *
     * @return is_finish - 是否完成（0未完成 1已完成）
     */
    public Boolean getIsFinish() {
        return isFinish;
    }

    /**
     * 设置是否完成（0未完成 1已完成）
     *
     * @param isFinish 是否完成（0未完成 1已完成）
     */
    public void setIsFinish(Boolean isFinish) {
        this.isFinish = isFinish;
    }

	public String getCreateName() {
		return createName;
	}

	public void setCreateName(String createName) {
		this.createName = createName;
	}

	public List<TrainPaperFile> getFileList() {
		return fileList;
	}

	public void setFileList(List<TrainPaperFile> fileList) {
		this.fileList = fileList;
	}
	
	public String getFileName() {
		return fileName;
	}

	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	public String getBudget() {
		return budget;
	}

	public void setBudget(String budget) {
		this.budget = budget;
	}

	
    
}