package cn.smarthse.modules.health.entity.work.train;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class TrainPlanImportVo implements Serializable {

    private static final long serialVersionUID = -7940005270451236655L;


    private Long staffId;

    private String workNo;

    /**
     * 用户姓名
     */
    private String staffName;

    /**
     * 完成时所在组织
     */
    private String deptName;

    private Long deptId;

    /**
     * 完成时所在职务
     */
    private String workName;

    private Long workId;

    /**
     * 课程名称
     */
    private String name;

    /**
     * 课程分类
     */
    private String hsType;

    /**
     * 课程类型
     */
    private String type;

    /**
     * 课时
     */
    private String classCount;

    /**
     * 完成时间
     */
    private Date updateDate;

    private Integer rowIndex;

    /**
     * 导入的状态,1:正常的状态,默认为1 ，2是数据存在错误的状态 3是数据在数据库已存在的状态 4表示跳过改行不更新（Excel每行没有必填数据或者该行数据为空）
     */
    private Byte dataState;

    private Long cid;

    private Long loginStaffId;

    /**
     * 不能导入数据的原因
     */
    private String errorReason;
}