package cn.smarthse.modules.health.entity.work.train;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.io.Serializable;
import java.util.Date;

/**
 * @author 邓力宾
 * @date 2022-02-08 10:17:34
 */
@Data
public class TrainPlanExamUserAnswer implements Serializable {

    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;



    /**
     * 培训ID
     */
    @Column(name = "train_plain_id")
    private Long trainPlainId;

    /**
     * 人员id
     */
    @Column(name = "staff_id")
    private Long staffId;



    /**
     * 题目id
     */
    @Column(name = "question_id")
    private Long questionId;


    /**
     * 用户答案
     */
    @Column(name = "answer")
    private String answer;

    /**
     * 提交编号
     */
    @Column(name = "submit_no")
    private String submitNo;




    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;



    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;
}
