package cn.smarthse.modules.health.entity.work.train;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * @author 邓力宾
 * @date 2022/2/8 13:58
 * @desc
 */
@Data
public class TrainPlanExamRecord implements Serializable {

    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;



    /**
     * 培训ID
     */
    @Column(name = "train_plain_id")
    private Long trainPlainId;

    @Transient
    private Long examId;
    public  Long getExamId(){
        return this.trainPlainId;
    }



    /**
     * 人员id
     */
    @Column(name = "staff_id")
    private Long staffId;

    /**
     * 得分
     */
    @Column(name = "score")
    private Integer score;

    /**
     * 是否合格
     */
    @Column(name = "pass")
    private Boolean pass;

    /**
     * 考试时间
     */
    @Column(name = "exam_date")
    private Date examDate;




    /**
     * 提交编号
     */
    @Column(name = "submit_no")
    private String submitNo;


    /**
     * 答题耗时 秒
     */
    @Column(name = "seconds")
    private Integer seconds;






    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;



    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;
}
