package cn.smarthse.modules.health.entity.work.train;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Table(name = "train_plan_count")
public class TrainPlanCount implements Serializable{
    

	/**
     *   ID
     */
	@Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     *   企业Id
     */
    private Long cid;

    /**
     *   区域Id
     */
    @Column(name = "area_id")
    private Long areaId;

    /**
     *   注册类型
     */
    @Column(name = "register_type")
    private Long registerType;

    /**
     *   行业分类（sys_param.param_code）
     */
    @Column(name = "industry_category")
    private Long industryCategory;

    /**
     *   职业病危害风险分类(0-严重、1-较重、2-一般)
     */
    @Column(name = "occupational_risk_classify")
    private Byte occupationalRiskClassify;

    /**
     *   企业规模
     */
    private String scale;

    /**
     *   职业卫生管理人员数量(V3.0不需要)
     */
    @Column(name = "manager_num")
    private Integer managerNum;

    /**
     *   专职职业卫生管理人员数量(V3.0不需要)
     */
    @Column(name = "full_time_num")
    private Integer fullTimeNum;

    /**
     *   兼职职业卫生管理人员数量(V3.0不需要)
     */
    @Column(name = "part_time_num")
    private Integer partTimeNum;

    /**
     *   (V3.0职业卫生管理人员)证书有效人员数量
     */
    @Column(name = "cert_effective_num")
    private Integer certEffectiveNum;
    /**
     *   职业卫生管理人员配备情况（1：配备，0：未配备)
     */
    @Column(name = "equipment_hse_Mana")
    private Integer equipmentHseMana;

    /**
     *   (V3.0主要负责人)证书有效人员数量
     */
    @Column(name = "cert_effective_num_main")
    private Integer certEffectiveNumMain;


    /**
     *   主要负责人配备情况（1：配备，0：未配备)
     */
    @Column(name = "main_hse_mana")
    private Integer mainHseMana;

    /**
     *   (培训企业数)职业卫生培训情况（1：培训，0：未培训)
     */
    @Column(name = "mana_train_info")
    private Integer manaTrainInfo;
    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建者ID
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后更新时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后更新人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     *   是否有效(1-有效,0-无效
     */
    @Column(name = "is_valid")
    private Boolean isValid;
    /**
     *   企业数量
     */
    @Transient
    private Integer comNum;
    /**
     *   类型名称
     */
    @Transient
    private String typeName;
    /**
     *   职业健康管理人员配备率
     */
    @Transient
    private Float equipmentRate;
    @Transient
    private String equipmentRateStr;

    /**
     *   主要负责人配备率
     */
    @Transient
    private Float mainHseManaRate;
    @Transient
    private String mainHseManaRateStr;


    /**
     *   企业主要负责人培训率
     */
    @Transient
    private Float trainRate;
    @Transient
    private String trainRateStr;
   
    
    @Transient
    private Integer level;

    @Transient
    private String trainedCids; //已培训的企业id

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getCid() {
        return cid;
    }

    public void setCid(Long cid) {
        this.cid = cid;
    }

    public Long getAreaId() {
        return areaId;
    }

    public void setAreaId(Long areaId) {
        this.areaId = areaId;
    }

    public Long getRegisterType() {
        return registerType;
    }

    public void setRegisterType(Long registerType) {
        this.registerType = registerType;
    }

    public Long getIndustryCategory() {
        return industryCategory;
    }

    public void setIndustryCategory(Long industryCategory) {
        this.industryCategory = industryCategory;
    }

    public Byte getOccupationalRiskClassify() {
        return occupationalRiskClassify;
    }

    public void setOccupationalRiskClassify(Byte occupationalRiskClassify) {
        this.occupationalRiskClassify = occupationalRiskClassify;
    }

    public String getScale() {
        return scale;
    }

    public void setScale(String scale) {
        this.scale = scale == null ? null : scale.trim();
    }

    public Integer getManagerNum() {
        return managerNum;
    }

    public void setManagerNum(Integer managerNum) {
        this.managerNum = managerNum;
    }

    public Integer getFullTimeNum() {
        return fullTimeNum;
    }

    public void setFullTimeNum(Integer fullTimeNum) {
        this.fullTimeNum = fullTimeNum;
    }

    public Integer getPartTimeNum() {
        return partTimeNum;
    }

    public void setPartTimeNum(Integer partTimeNum) {
        this.partTimeNum = partTimeNum;
    }

    public Integer getCertEffectiveNum() {
        return certEffectiveNum;
    }

    public void setCertEffectiveNum(Integer certEffectiveNum) {
        this.certEffectiveNum = certEffectiveNum;
    }

    public Integer getEquipmentHseMana() {
        return equipmentHseMana;
    }

    public void setEquipmentHseMana(Integer equipmentHseMana) {
        this.equipmentHseMana = equipmentHseMana;
    }

    public Integer getManaTrainInfo() {
        return manaTrainInfo;
    }

    public void setManaTrainInfo(Integer manaTrainInfo) {
        this.manaTrainInfo = manaTrainInfo;
    }

    public Boolean getIsValid() {
        return isValid;
    }

    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

	public Date getCreateDate() {
		return createDate;
	}

	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}

	public Long getCreateBy() {
		return createBy;
	}

	public void setCreateBy(Long createBy) {
		this.createBy = createBy;
	}

	public Date getUpdateDate() {
		return updateDate;
	}

	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}

	public Long getUpdateBy() {
		return updateBy;
	}

	public void setUpdateBy(Long updateBy) {
		this.updateBy = updateBy;
	}

	public Integer getComNum() {
		return comNum;
	}

	public void setComNum(Integer comNum) {
		this.comNum = comNum;
	}

	public String getTypeName() {
		return typeName;
	}

	public void setTypeName(String typeName) {
		this.typeName = typeName;
	}

	

	public Float getEquipmentRate() {
		return equipmentRate;
	}

	public void setEquipmentRate(Float equipmentRate) {
		this.equipmentRate = equipmentRate;
	}

	public String getEquipmentRateStr() {
		return equipmentRateStr;
	}

	public void setEquipmentRateStr(String equipmentRateStr) {
		this.equipmentRateStr = equipmentRateStr;
	}

	public Float getTrainRate() {
		return trainRate;
	}

	public void setTrainRate(Float trainRate) {
		this.trainRate = trainRate;
	}

	public String getTrainRateStr() {
		return trainRateStr;
	}

	public void setTrainRateStr(String trainRateStr) {
		this.trainRateStr = trainRateStr;
	}

	public Integer getLevel() {
		return level;
	}

	public void setLevel(Integer level) {
		this.level = level;
	}

    public Integer getCertEffectiveNumMain() {
        return certEffectiveNumMain;
    }

    public void setCertEffectiveNumMain(Integer certEffectiveNumMain) {
        this.certEffectiveNumMain = certEffectiveNumMain;
    }

    public Integer getMainHseMana() {
        return mainHseMana;
    }

    public void setMainHseMana(Integer mainHseMana) {
        this.mainHseMana = mainHseMana;
    }

    public Float getMainHseManaRate() {
        return mainHseManaRate;
    }

    public void setMainHseManaRate(Float mainHseManaRate) {
        this.mainHseManaRate = mainHseManaRate;
    }

    public String getTrainedCids() {
        return trainedCids;
    }

    public void setTrainedCids(String trainedCids) {
        this.trainedCids = trainedCids;
    }

    public String getMainHseManaRateStr() {
        return mainHseManaRateStr;
    }

    public void setMainHseManaRateStr(String mainHseManaRateStr) {
        this.mainHseManaRateStr = mainHseManaRateStr;
    }


}