package cn.smarthse.modules.health.entity.work.train;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.health.enums.train.TrainHsTypeEnum;
import cn.smarthse.modules.health.enums.train.TrainOnLineEnum;
import cn.smarthse.modules.health.enums.train.TrainWayEnum;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Table(name = "train_plan")
@Data
public class TrainPlan implements Serializable {

    private static final long serialVersionUID = 6708162357947035630L;

    /**
     * 培训ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;
    /**
     * 企业ID
     */
    private Long cid;
    /**
     * 培训编号
     */
    private String no;
    /**
     * 培训名称
     */
    private String name;
    /**
     * 培训类型 对应：职业卫生、安全，以逗号分隔。
     */
    @Column(name = "hs_type")
    private String hsType;
    /**
     * 培训类型
     */
    private String type;
    /**
     * 培训方式
     */
    private Byte way;
    /**
     * 线上线下(1.线下，2线上)
     */
    @Column(name = "on_line")
    private Byte onLine;
    /**
     * 培训方式描述
     */
    @Column(name = "way_desc")
    private String wayDesc;
    /**
     * 组织部门或单位
     */
    @Column(name = "organize_dept")
    private String organizeDept;
    /**
     * 协同部门
     */
    @Column(name = "coordination_dept")
    private String coordinationDept;
    /**
     * 主讲人
     */
    private Long teacher;
    /**
     * 主讲人姓名
     */
    @Column(name = "teacher_name")
    private String teacherName;
    /**
     * 主讲人部门/单位
     */
    @Column(name = "teacher_dept")
    private String teacherDept;
    /**
     * 课时
     */
    @Column(name = "class_count")
    private String classCount;
    /**
     * 培训实施时间
     */
    @Column(name = "register_time")
    private Date registerTime;
    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;
    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;
    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;
    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;
    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;
    /**
     * 是否完成（0未完成 1已完成）
     */
    @Column(name = "is_finish")
    private Boolean isFinish;
    /**
     * 状态（1、正常；-2、作废)
     */
    @Column(name = "status")
    private Byte status;

    @Column(name = "train_attend")
    private String trainAttend;
    /**
     * 创建人姓名
     */
    @Transient
    private String createName;
    /**
     * 组织单位（真实数据存在organizeDept里面（企业简化版））
     */
    @Transient
    private String compName;
    /**
     * 关键工作提醒来源对应CoreWorkEnum
     */
    @Column(name = "from_type")
    private Byte fromType;
    /**
     * 提醒id
     */
    @Column(name = "from_id")
    private Long fromId;
    /**
     * 组织部门id
     */
    @Column(name = "org_id")
    private String orgId;
    /**
     * 服务机构id
     */
    @Column(name = "third_org_id")
    private Long thirdOrgId;
    /**
     * 数据来源：1企业端 2机构端上报 3在线培训-职业健康在线 4其他来源（培训系统导入的数据） 1和2算其他
     * 注：之前（3.2.2.2优化版本之前）同步的数据都是3培训系统来源
     */
    @Column(name = "data_source")
    private Byte dataSource;
    /**
     * 登记人
     */
    private String registrant;
    /**
     * 培训项目上报表train_proj_report的id，培训系统对应培训id
     */
    @Column(name = "report_id")
    private Long reportId;
    /**
     * 是否需要在线考试
     */
    @Column(name = "need_online_train")
    private Boolean needOnlineTrain;
    /**
     * 在线培训
     */
    @Column(name = "online_train")
    private Boolean onlineTrain;
    /**
     * 在线考试
     */
    @Column(name = "online_test")
    private Boolean onlineTest;
    /**
     * 培训教材id多个用,分隔
     */
    @Column(name = "train_materials_ids")
    private String trainMaterialsIds;
    /**
     * 在线考试设置id
     */
    @Column(name = "exam_setup_id")
    private Long examSetupId;
    /**
     * 培训内容
     */
    @Column(name = "train_content")
    private String trainContent;

    /**
     *  主要负责人状态
     *  0 : 未开始 1 : 进行中 2 : 已完成
     */
    @Column(name = "key_person_status")
    private Byte keyPersonStatus;

    /**
     *  管理人员状态
     *  0 : 未开始 1 : 进行中 2 : 已完成
     */
    @Column(name = "manage_person_status")
    private Byte managePersonStatus;

    /**
     * 在线培训教材
     */
    @Transient
    private List<TrainBook> videos;
    /**
     * 培训参与人员信息
     */
    @Transient
    private List<TrainAttend> attends;
    /**
     * 培训参与人员姓名
     * <p>
     * 格式：姓名/工号
     */
    @Transient
    private String attendNames;
    /**
     * 培训签到单
     */
    @Transient
    private List<TrainPaperFile> signFiles;
    /**
     * 培训成绩单
     */
    @Transient
    private List<TrainPaperFile> scoreFiles;
    /**
     * 培训影像资料
     */
    @Transient
    private List<TrainPaperFile> medioFiles;
    /**
     * 其他附件（可用于上传讲师资质、培训评估、培训反馈表等内容）
     */
    @Transient
    private List<TrainPaperFile> otherFiles;
    /**
     * 培训教材
     */
    @Transient
    private List<TrainPaperFile> books;
    /**
     * 培训考核试卷
     */
    @Transient
    private List<TrainPaperFile> exams;
    /**
     * 实施版培训教材
     */
    @Transient
    private List<TrainBook> trainBooks;
    /**
     * 实施版培训考核试卷
     */
    @Transient
    private List<TrainExam> trainExams;
    /**
     * 培训类型名称
     */
    @Transient
    private String typeName;
    /**
     * 参加培训部门
     */
    @Transient
    private String attendDepts;
    /**
     * 所有附件名称
     */
    @Transient
    private String fileName;
    /**
     * 状态名称
     */
    @Transient
    private String statusName;
    /**
     * 培训教材和试卷附件
     */
    @Transient
    private List<SysFileModel> btFiles;
    @Transient
    private List<String> trainTypes;
    /**
     * 协同部门id
     */
    @Transient
    private List<Long> coordDeptIds;

    @Transient
    private Integer year;

    @Transient
    private Integer trainNumber; //培训人数
    @Transient
    private Integer noTrainNum; //未培训人数
    @Transient
    private Integer trainingNum; //培训中人数
    @Transient
    private Integer trainedNum; //已培训人数

    @Transient
    private Integer notTestCount; //未考试人数
    @Transient
    private Integer noPassCount; //不合格人数
    @Transient
    private Integer passCount; //合格人数

    @Transient
    private Boolean isOverYear; //是否历年
    @Transient
    private Integer thisYear;

    @Transient
    private String attendOrgNames; //参与部门

    @Transient
    private Integer staffTestStatus; //0 未考试  1 不合格 2 合格
    @Transient
    private Boolean isHasBack;

    /**
     * 培训类型名称
     */
    @Transient
    private String hsTypeName;

    /**
     * 方式名称
     * <p>
     * 内部、线上；内部、线下；外部、线上；外部、线下
     */
    @Transient
    private String wayAndOnLine;

    @Transient
    private String[] colums;

    public void setHsTypeName(String hsType) {
        StringBuilder hsTypeName2 = new StringBuilder();
        if (!StringUtils.isEmpty(hsType)) {
            List<Integer> types = StringUtils.parseToIntegerList(hsType, ",");
            for (int i = 0; i < types.size(); i++) {
                hsTypeName2.append(TrainHsTypeEnum.getName(types.get(i)));
                if (i < types.size() - 1) {
                    hsTypeName2.append(" | ");
                }
            }
        }
        this.hsTypeName = hsTypeName2.toString();
    }

    public void setWayAndOnLine(Byte way, Byte onLine) {
//        if (hsType == null) {
//            this.wayAndOnLine = this.getWay() + "、" + TrainOnLineEnum.getName(onLine);
//        } else {
        this.wayAndOnLine = TrainWayEnum.getName(way) + "、" + TrainOnLineEnum.getName(onLine);
//        }
    }
}
