package cn.smarthse.modules.health.entity.work.train;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "train_paper_file")
public class TrainPaperFile implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 培训ID
     */
    @Column(name = "train_id")
    private Long trainId;

    /**
     * 培训总结id
     */
    @Column(name = "train_summary_id")
    private Long trainSummaryId;
    /**
     * 培训相关资料id
     */
    @Column(name = "train_file_id")
    private Long trainFileId;

    /**
     * 文件id
     */
    @Column(name = "file_Id")
    private Long fileId;

    /**
     * 文件名称
     */
    @Column(name = "file_name")
    private String fileName;

    /**
     * 文件地址
     */
    @Column(name = "file_url")
    private String fileUrl;

    /**
     * 文件类型（1.培训签到单，2培训成绩单，3培训影像资料，4培训总结附件
     */
    private Byte type;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取培训ID
     *
     * @return train_id - 培训ID
     */
    public Long getTrainId() {
        return trainId;
    }

    /**
     * 设置培训ID
     *
     * @param trainId 培训ID
     */
    public void setTrainId(Long trainId) {
        this.trainId = trainId;
    }

    /**
     * 获取培训总结id
     *
     * @return train_summary_id - 培训总结id
     */
    public Long getTrainSummaryId() {
        return trainSummaryId;
    }

    /**
     * 设置培训总结id
     *
     * @param trainSummaryId 培训总结id
     */
    public void setTrainSummaryId(Long trainSummaryId) {
        this.trainSummaryId = trainSummaryId;
    }
    
    public Long getTrainFileId() {
		return trainFileId;
	}

	public void setTrainFileId(Long trainFileId) {
		this.trainFileId = trainFileId;
	}

	/**
     * 获取文件id
     *
     * @return file_Id - 文件id
     */
    public Long getFileId() {
        return fileId;
    }

    /**
     * 设置文件id
     *
     * @param fileId 文件id
     */
    public void setFileId(Long fileId) {
        this.fileId = fileId;
    }

    /**
     * 获取文件名称
     *
     * @return file_name - 文件名称
     */
    public String getFileName() {
        return fileName;
    }

    /**
     * 设置文件名称
     *
     * @param fileName 文件名称
     */
    public void setFileName(String fileName) {
        this.fileName = fileName == null ? null : fileName.trim();
    }

    /**
     * 获取文件地址
     *
     * @return file_url - 文件地址
     */
    public String getFileUrl() {
        return fileUrl;
    }

    /**
     * 设置文件地址
     *
     * @param fileUrl 文件地址
     */
    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl == null ? null : fileUrl.trim();
    }

    /**
     * 获取文件类型（1.培训签到单，2培训成绩单，3培训影像资料，4培训总结附件
     *
     * @return type - 文件类型（1.培训签到单，2培训成绩单，3培训影像资料，4培训总结附件
     */
    public Byte getType() {
        return type;
    }

    /**
     * 设置文件类型（1.培训签到单，2培训成绩单，3培训影像资料，4培训总结附件
     *
     * @param type 文件类型（1.培训签到单，2培训成绩单，3培训影像资料，4培训总结附件
     */
    public void setType(Byte type) {
        this.type = type;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }
}